/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.lib.inventory.InjectableWrapper;
import buildcraft.lib.inventory.InventoryWrapper;
import buildcraft.lib.inventory.ItemHandlerWrapper;
import buildcraft.lib.inventory.NoSpaceInjectable;
import buildcraft.lib.inventory.NoSpaceTransactor;
import buildcraft.lib.inventory.SidedInventoryWrapper;
import buildcraft.lib.inventory.TransactorEntityArrow;
import buildcraft.lib.inventory.TransactorEntityItem;
import buildcraft.lib.misc.CapUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class ItemTransactorHelper {
    @Nonnull
    public static IItemTransactor getTransactor(ICapabilityProvider provider, EnumFacing face) {
        if (provider == null) {
            return NoSpaceTransactor.INSTANCE;
        }
        IItemTransactor trans = (IItemTransactor)provider.getCapability(CapUtil.CAP_ITEM_TRANSACTOR, face);
        if (trans != null) {
            return trans;
        }
        IItemHandler handler = (IItemHandler)provider.getCapability(CapUtil.CAP_ITEMS, face);
        if (handler == null) {
            if (provider instanceof ISidedInventory) {
                return new SidedInventoryWrapper((ISidedInventory)provider, face);
            }
            if (provider instanceof IInventory) {
                return new InventoryWrapper((IInventory)provider);
            }
            return NoSpaceTransactor.INSTANCE;
        }
        if (handler instanceof IItemTransactor) {
            return (IItemTransactor)handler;
        }
        return new ItemHandlerWrapper(handler);
    }

    @Nonnull
    public static IItemTransactor getTransactor(InventoryPlayer inventory) {
        if (inventory == null) {
            return NoSpaceTransactor.INSTANCE;
        }
        return new InventoryWrapper((IInventory)inventory);
    }

    @Nonnull
    public static IItemTransactor getTransactorForEntity(Entity entity, EnumFacing face) {
        IItemTransactor transactor = ItemTransactorHelper.getTransactor((ICapabilityProvider)entity, face);
        if (transactor != NoSpaceTransactor.INSTANCE) {
            return transactor;
        }
        if (entity instanceof EntityItem) {
            return new TransactorEntityItem((EntityItem)entity);
        }
        if (entity instanceof EntityArrow) {
            return new TransactorEntityArrow((EntityArrow)entity);
        }
        return NoSpaceTransactor.INSTANCE;
    }

    @Nonnull
    public static IInjectable getInjectable(ICapabilityProvider provider, EnumFacing face) {
        if (provider == null) {
            return NoSpaceInjectable.INSTANCE;
        }
        IInjectable injectable = (IInjectable)provider.getCapability(PipeApi.CAP_INJECTABLE, face);
        if (injectable == null) {
            return NoSpaceInjectable.INSTANCE;
        }
        return injectable;
    }

    public static IItemTransactor wrapInjectable(IInjectable injectable, EnumFacing facing) {
        return new InjectableWrapper(injectable, facing);
    }

    public static NonNullList<ItemStack> insertAllBypass(IItemTransactor transactor, NonNullList<ItemStack> stacks, boolean simulate) {
        NonNullList leftOver = NonNullList.func_191196_a();
        for (ItemStack stack : stacks) {
            ItemStack leftOverStack = transactor.insert(stack, false, simulate);
            if (leftOverStack.func_190926_b()) continue;
            leftOver.add((Object)leftOverStack);
        }
        return leftOver;
    }
}

