/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.IInjectable;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class InjectableWrapper
implements IItemTransactor {
    private final IInjectable injectable;
    private final EnumFacing from;

    public InjectableWrapper(IInjectable injectable, EnumFacing facing) {
        this.injectable = injectable;
        this.from = facing;
    }

    @Override
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack stack, boolean allOrNone, boolean simulate) {
        if (allOrNone) {
            ItemStack leftOver = this.injectable.injectItem(stack, false, this.from, null, 0.0);
            if (leftOver.func_190926_b()) {
                ItemStack reallyLeftOver = this.injectable.injectItem(stack, !simulate, this.from, null, 0.0);
                if (!reallyLeftOver.func_190926_b()) {
                    throw new IllegalStateException("Found an invalid IInjectable instance! (leftOver = " + leftOver + ", reallyLeftOver = " + reallyLeftOver + ", " + this.injectable.getClass() + ")");
                }
                return StackUtil.EMPTY;
            }
            return stack;
        }
        return this.injectable.injectItem(stack, !simulate, this.from, null, 0.0);
    }

    @Override
    public NonNullList<ItemStack> insert(NonNullList<ItemStack> stacks, boolean simulate) {
        return ItemTransactorHelper.insertAllBypass(this, stacks, simulate);
    }

    @Override
    @Nonnull
    public ItemStack extract(IStackFilter filter, int min, int max, boolean simulate) {
        return StackUtil.EMPTY;
    }
}

