/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.widget;

import buildcraft.lib.fluid.Tank;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.Widget_Neptune;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetFluidTank
extends Widget_Neptune<ContainerBC_Neptune> {
    private static final byte NET_CLICK = 0;
    private final Tank tank;

    public WidgetFluidTank(ContainerBC_Neptune container, Tank tank) {
        super(container);
        this.tank = tank;
    }

    @Override
    public IMessage handleWidgetDataServer(MessageContext ctx, PacketBufferBC buffer) throws IOException {
        byte id = buffer.readByte();
        if (id == 0) {
            this.tank.onGuiClicked(this.container);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiElement createGuiElement(GuiBC8<?> gui, IGuiPosition parent, GuiRectangle position, GuiIcon overlay) {
        return new GuiElementFluidTank(gui, parent, position, overlay);
    }

    private final class GuiElementFluidTank
    extends GuiElementSimple<GuiBC8<?>> {
        private final GuiIcon overlay;

        public GuiElementFluidTank(GuiBC8<?> gui, IGuiPosition parent, GuiRectangle position, GuiIcon overlay) {
            super(gui, parent, position);
            this.overlay = overlay;
        }

        @Override
        public void drawBackground(float partialTicks) {
            GuiUtil.drawFluid(this, WidgetFluidTank.this.tank);
            if (this.overlay != null) {
                this.overlay.drawCutInside(this);
            }
        }

        @Override
        public void onMouseClicked(int button) {
            if (this.contains(this.gui.mouse)) {
                WidgetFluidTank.this.sendWidgetData(buffer -> buffer.writeByte(0));
            }
        }

        @Override
        public void addToolTips(List<ToolTip> tooltips) {
            if (this.contains(this.gui.mouse)) {
                ToolTip tooltip = WidgetFluidTank.this.tank.getToolTip();
                tooltip.refresh();
                tooltips.add(tooltip);
            }
        }

        @Override
        public ElementHelpInfo.HelpPosition getHelpInfo() {
            return ((WidgetFluidTank)WidgetFluidTank.this).tank.helpInfo.target(this.expand(4));
        }
    }
}

