/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.pos;

import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;
import javax.annotation.Nonnull;

public class PositionOffset
implements IGuiPosition {
    @Nonnull
    public final IGuiPosition parent;
    public final int xOffset;
    public final int yOffset;

    private PositionOffset(@Nonnull IGuiPosition parent, int xOffset, int yOffset) {
        this.parent = parent;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public static IGuiPosition createOffset(IGuiPosition from, int x, int y) {
        if (from == null) {
            return new PositionAbsolute(x, y);
        }
        if (from instanceof PositionOffset) {
            PositionOffset parent = (PositionOffset)from;
            int oX = x + parent.xOffset;
            int oY = y + parent.yOffset;
            return parent.parent.offset(oX, oY);
        }
        return new PositionOffset(from, x, y);
    }

    @Override
    public int getX() {
        return this.parent.getX() + this.xOffset;
    }

    @Override
    public int getY() {
        return this.parent.getY() + this.yOffset;
    }

    @Override
    public IGuiPosition offset(int x, int y) {
        return new PositionOffset(this.parent, x + this.xOffset, y + this.yOffset);
    }

    @Override
    public IGuiPosition offset(IGuiPosition by) {
        if (by instanceof PositionOffset) {
            return this.offset(by.getX(), by.getY());
        }
        return IGuiPosition.super.offset(by);
    }
}

