/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.pos;

import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.function.IntSupplier;

public interface IGuiArea
extends IGuiPosition {
    public int getWidth();

    public int getHeight();

    default public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    default public int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    default public int getEndX() {
        return this.getX() + this.getWidth();
    }

    default public int getEndY() {
        return this.getY() + this.getHeight();
    }

    default public boolean contains(int x, int y) {
        if (x < this.getX() || x >= this.getEndX()) {
            return false;
        }
        return y >= this.getY() && y < this.getEndY();
    }

    default public boolean contains(IGuiPosition position) {
        return this.contains(position.getX(), position.getY());
    }

    default public boolean contains(IGuiArea element) {
        if (element.getX() < this.getX() || element.getEndX() >= this.getEndX()) {
            return false;
        }
        return element.getY() >= this.getY() && element.getEndY() < this.getEndY();
    }

    default public String rectangleToString() {
        return "[x = " + this.getX() + ", y = " + this.getY() + ", w = " + this.getWidth() + ", h = " + this.getHeight() + "]";
    }

    default public GuiRectangle asImmutable() {
        return new GuiRectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    default public IGuiArea offset(IGuiPosition by) {
        return this.offset(by::getX, by::getY);
    }

    @Override
    default public IGuiArea offset(int x, IntSupplier y) {
        return this.offset(() -> x, y);
    }

    @Override
    default public IGuiArea offset(IntSupplier x, int y) {
        return this.offset(x, () -> y);
    }

    @Override
    default public IGuiArea offset(IntSupplier x, IntSupplier y) {
        return IGuiArea.create(() -> this.getX() + x.getAsInt(), () -> this.getY() + y.getAsInt(), this::getWidth, this::getHeight);
    }

    @Override
    default public IGuiArea offset(int x, int y) {
        return IGuiArea.create(() -> this.getX() + x, () -> this.getY() + y, this::getWidth, this::getHeight);
    }

    default public IGuiArea resize(int newWidth, int newHeight) {
        return IGuiArea.create(this::getX, this::getY, () -> newWidth, () -> newHeight);
    }

    default public IGuiArea expand(int by) {
        return this.expand(by, by);
    }

    default public IGuiArea expand(int dX, int dY) {
        return IGuiArea.create(() -> this.getX() - dX, () -> this.getY() - dY, () -> this.getWidth() + dX * 2, () -> this.getHeight() + dY * 2);
    }

    public static IGuiArea create(final IntSupplier x, final IntSupplier y, final IntSupplier width, final IntSupplier height) {
        return new IGuiArea(){

            @Override
            public int getX() {
                return x.getAsInt();
            }

            @Override
            public int getY() {
                return y.getAsInt();
            }

            @Override
            public int getWidth() {
                return width.getAsInt();
            }

            @Override
            public int getHeight() {
                return height.getAsInt();
            }
        };
    }
}

