/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.ledger;

import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.ISprite;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.ITooltipElement;
import buildcraft.lib.gui.elem.GuiElementDrawable;
import buildcraft.lib.gui.elem.GuiElementText;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.ledger.LedgerManager_Neptune;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionCallable;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public abstract class Ledger_Neptune
implements ITooltipElement {
    public static final SpriteHolderRegistry.SpriteHolder SPRITE_EXP_NEG = BCLibSprites.LEDGER_LEFT;
    public static final SpriteHolderRegistry.SpriteHolder SPRITE_EXP_POS = BCLibSprites.LEDGER_RIGHT;
    public static final SpriteNineSliced SPRITE_SPLIT_NEG = new SpriteNineSliced((ISprite)SPRITE_EXP_NEG, 4, 4, 12, 12, 16);
    public static final SpriteNineSliced SPRITE_SPLIT_POS = new SpriteNineSliced((ISprite)SPRITE_EXP_POS, 4, 4, 12, 12, 16);
    public static final int LEDGER_CHANGE_DIFF = 20;
    public static final int LEDGER_GAP = 4;
    public static final int CLOSED_WIDTH = 22;
    public static final int CLOSED_HEIGHT = 24;
    public final LedgerManager_Neptune manager;
    public final IGuiPosition positionLedgerStart = new PositionCallable(this::getX, this::getY);
    public final IGuiPosition positionLedgerIconStart = this.positionLedgerStart.offset(2, 4);
    public final IGuiPosition positionLedgerInnerStart = this.positionLedgerIconStart.offset(20, 0);
    protected int maxWidth = 96;
    protected int maxHeight = 48;
    protected int currentWidth = 22;
    protected int currentHeight = 24;
    protected int lastWidth = this.currentWidth;
    protected int lastHeight = this.currentHeight;
    protected int interpWidth = this.lastWidth;
    protected int interpHeight = this.lastHeight;
    protected final List<IGuiElement> closedElements = new ArrayList<IGuiElement>();
    protected final List<IGuiElement> openElements = new ArrayList<IGuiElement>();
    protected IGuiPosition positionAppending = this.positionLedgerInnerStart.offset(0, 3);
    protected String title = "unknown";
    private int currentDifference = 0;
    private int startX;
    private int startY;

    public Ledger_Neptune(LedgerManager_Neptune manager) {
        this.manager = manager;
        GuiRectangle iconRect = new GuiRectangle(0, 0, 16, 16);
        ISimpleDrawable drawable = this::drawIcon;
        GuiBC8<?> gui = manager.gui;
        this.closedElements.add(new GuiElementDrawable(gui, this.positionLedgerIconStart, iconRect, drawable, false));
        this.appendText(this::getTitle, this::getTitleColour).setDropShadow(true);
        this.calculateMaxSize();
    }

    protected GuiElementText appendText(String text, int colour) {
        return this.appendText(() -> text, colour);
    }

    protected GuiElementText appendText(Supplier<String> text, int colour) {
        return this.appendText(text, () -> colour);
    }

    protected GuiElementText appendText(Supplier<String> text, IntSupplier colour) {
        return this.append(new GuiElementText(this.manager.gui, this.positionAppending, text, colour));
    }

    protected <T extends IGuiElement> T append(T element) {
        this.openElements.add(element);
        this.positionAppending = this.positionAppending.offset(() -> 0, () -> 3 + element.getHeight());
        return element;
    }

    protected void calculateMaxSize() {
        int w = 22;
        int h = 24;
        for (IGuiElement element : this.openElements) {
            w = Math.max(w, element.getEndX());
            h = Math.max(h, element.getEndY());
        }
        this.maxWidth = (w -= this.getX()) + 8;
        this.maxHeight = (h -= this.getY()) + 8;
    }

    public void update() {
        this.lastWidth = this.currentWidth;
        this.lastHeight = this.currentHeight;
        int targetWidth = this.currentWidth;
        int targetHeight = this.currentHeight;
        if (this.currentDifference == 1) {
            targetWidth = this.maxWidth;
            targetHeight = this.maxHeight;
        } else if (this.currentDifference == -1) {
            targetWidth = 22;
            targetHeight = 24;
        } else {
            return;
        }
        int maxDiff = Math.max(this.maxWidth - 22, this.maxHeight - 24);
        int ldgDiff = MathHelper.func_76125_a((int)(maxDiff / 5), (int)1, (int)15);
        if (this.currentWidth < targetWidth) {
            this.currentWidth += ldgDiff;
            if (this.currentWidth > targetWidth) {
                this.currentWidth = targetWidth;
            }
        } else if (this.currentWidth > targetWidth) {
            this.currentWidth -= ldgDiff;
            if (this.currentWidth < targetWidth) {
                this.currentWidth = targetWidth;
            }
        }
        if (this.currentHeight < targetHeight) {
            this.currentHeight += ldgDiff;
            if (this.currentHeight > targetHeight) {
                this.currentHeight = targetHeight;
            }
        } else if (this.currentHeight > targetHeight) {
            this.currentHeight -= ldgDiff;
            if (this.currentHeight < targetHeight) {
                this.currentHeight = targetHeight;
            }
        }
    }

    private static int interp(int past, int current, float partialTicks) {
        if (past == current) {
            return current;
        }
        if (partialTicks <= 0.0f) {
            return past;
        }
        if (partialTicks >= 1.0f) {
            return current;
        }
        return (int)((float)past * (1.0f - partialTicks) + (float)current * partialTicks);
    }

    public GuiRectangle getEnclosingRectangle() {
        return new GuiRectangle(this.startX, this.startY, this.currentWidth, this.currentHeight);
    }

    public final boolean shouldDrawOpen() {
        return this.currentWidth > 22 || this.currentHeight > 24;
    }

    public void drawBackground(int x, int y, float partialTicks) {
        SpriteNineSliced split;
        this.startY = y;
        this.interpWidth = Ledger_Neptune.interp(this.lastWidth, this.currentWidth, partialTicks);
        this.interpHeight = Ledger_Neptune.interp(this.lastHeight, this.currentHeight, partialTicks);
        if (this.manager.expandPositive) {
            this.startX = x;
            split = SPRITE_SPLIT_POS;
        } else {
            this.startX = x - this.interpWidth;
            split = SPRITE_SPLIT_NEG;
        }
        RenderUtil.setGLColorFromIntPlusAlpha(this.getColour());
        split.draw(this.startX, this.startY, this.interpWidth, this.interpHeight);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IGuiPosition pos2 = this.manager.expandPositive ? this.positionLedgerIconStart : this.positionLedgerIconStart;
        GL11.glEnable((int)3089);
        GuiUtil.scissor(pos2.getX(), pos2.getY(), this.interpWidth - 4, this.interpHeight - 8);
        for (IGuiElement element : this.closedElements) {
            element.drawBackground(partialTicks);
        }
        if (this.shouldDrawOpen()) {
            for (IGuiElement element : this.openElements) {
                element.drawBackground(partialTicks);
            }
        }
        GL11.glDisable((int)3089);
    }

    public void drawForeground(int x, int y, float partialTicks) {
        GL11.glEnable((int)3089);
        GuiUtil.scissor(this.positionLedgerIconStart.getX(), this.positionLedgerIconStart.getY(), this.interpWidth - 8, this.interpHeight - 8);
        for (IGuiElement element : this.closedElements) {
            element.drawForeground(partialTicks);
        }
        if (this.shouldDrawOpen()) {
            for (IGuiElement element : this.openElements) {
                element.drawForeground(partialTicks);
            }
        }
        GL11.glDisable((int)3089);
    }

    public void onMouseClicked(int button) {
        if (this.getEnclosingRectangle().contains(this.manager.gui.mouse)) {
            this.currentDifference = this.currentDifference == 1 ? -1 : 1;
        }
    }

    public void onMouseDragged(int button, long ticksSinceClick) {
    }

    public void onMouseReleased(int button) {
    }

    protected void drawIcon(int x, int y) {
    }

    public abstract int getColour();

    public int getX() {
        return this.startX;
    }

    public int getY() {
        return this.startY;
    }

    public int getHeight(float partialTicks) {
        if (this.lastHeight == this.currentHeight) {
            return this.currentHeight;
        }
        if (partialTicks <= 0.0f) {
            return this.lastHeight;
        }
        if (partialTicks >= 1.0f) {
            return this.currentHeight;
        }
        return (int)((float)this.lastHeight * (1.0f - partialTicks) + (float)this.currentHeight * partialTicks);
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.title, (Object[])new Object[0]);
    }

    public int getTitleColour() {
        return -1980113;
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        for (IGuiElement element : this.closedElements) {
            element.addToolTips(tooltips);
        }
        if (this.shouldDrawOpen()) {
            for (IGuiElement element : this.openElements) {
                element.addToolTips(tooltips);
            }
        }
        if ((this.currentWidth != this.maxWidth || this.currentHeight != this.maxHeight) && this.getEnclosingRectangle().contains(this.manager.gui.mouse)) {
            tooltips.add(new ToolTip(this.getTitle()));
        }
    }
}

