/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.ledger;

import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.GuiElementContainer;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.ledger.LedgerManager_Neptune;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;

public class LedgerHelp
extends Ledger_Neptune {
    private static final SpriteNineSliced[][] SPRITE_HELP_SPLIT = new SpriteNineSliced[2][2];
    private IGuiElement selected = null;
    private boolean foundAny = false;
    private boolean init = false;

    public LedgerHelp(LedgerManager_Neptune manager) {
        super(manager);
        this.title = LocaleUtil.localize("gui.ledger.help");
        this.calculateMaxSize();
    }

    @Override
    public void update() {
        super.update();
        if (this.currentWidth == 22 && this.currentHeight == 24) {
            this.selected = null;
            if (this.openElements.size() == 2) {
                this.openElements.remove(1);
                this.title = LocaleUtil.localize("gui.ledger.help");
                this.calculateMaxSize();
            }
        }
    }

    @Override
    public int getColour() {
        return -3368449;
    }

    @Override
    protected void drawIcon(int x, int y) {
        if (!this.init) {
            this.init = true;
            for (IGuiElement element : this.manager.gui.guiElements) {
                ElementHelpInfo.HelpPosition info = element.getHelpInfo();
                if (info == null) continue;
                this.foundAny = true;
                break;
            }
        }
        SpriteHolderRegistry.SpriteHolder sprite = this.foundAny ? BCLibSprites.HELP : BCLibSprites.WARNING_MINOR;
        GuiIcon.draw(sprite, x, y, x + 16, y + 16);
    }

    @Override
    public void drawForeground(int x, int y, float partialTicks) {
        super.drawForeground(x, y, partialTicks);
        if (!this.shouldDrawOpen()) {
            return;
        }
        boolean set = false;
        for (IGuiElement element : this.manager.gui.guiElements) {
            ElementHelpInfo.HelpPosition info = element.getHelpInfo();
            if (info == null) continue;
            this.foundAny = true;
            IGuiArea rect = info.target;
            boolean isHovered = rect.contains(this.manager.gui.mouse);
            if (isHovered && this.selected != element && !set) {
                this.selected = element;
                GuiElementContainer container = new GuiElementContainer(this.manager.gui, this.positionLedgerInnerStart);
                info.info.addGuiElements(container);
                if (this.openElements.size() == 2) {
                    this.openElements.remove(1);
                }
                this.openElements.add(container);
                this.title = LocaleUtil.localize("gui.ledger.help") + ": " + LocaleUtil.localize(info.info.title);
                this.calculateMaxSize();
                set = true;
            }
            boolean isSelected = this.selected == element;
            SpriteNineSliced split = SPRITE_HELP_SPLIT[isHovered ? 1 : 0][isSelected ? 1 : 0];
            RenderUtil.setGLColorFromInt(info.info.colour);
            split.draw(rect);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        LedgerHelp.SPRITE_HELP_SPLIT[0][0] = BCLibSprites.HELP_SPLIT.subRelative(0, 0, 8, 8, 16).slice(2, 2, 6, 6, 8);
        LedgerHelp.SPRITE_HELP_SPLIT[0][1] = BCLibSprites.HELP_SPLIT.subRelative(0, 8, 8, 8, 16).slice(2, 2, 6, 6, 8);
        LedgerHelp.SPRITE_HELP_SPLIT[1][0] = BCLibSprites.HELP_SPLIT.subRelative(8, 0, 8, 8, 16).slice(2, 2, 6, 6, 8);
        LedgerHelp.SPRITE_HELP_SPLIT[1][1] = BCLibSprites.HELP_SPLIT.subRelative(8, 8, 8, 8, 16).slice(2, 2, 6, 6, 8);
    }
}

