/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.ledger;

import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.ledger.LedgerManager_Neptune;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.misc.LocaleUtil;

public class LedgerEngine
extends Ledger_Neptune {
    private static final int OVERLAY_COLOUR = -2855905;
    private static final int HEADER_COLOUR = -1980113;
    private static final int SUB_HEADER_COLOUR = -5591112;
    private static final int TEXT_COLOUR = -16777216;
    public final TileEngineBase_BC8 engine;

    public LedgerEngine(LedgerManager_Neptune manager, TileEngineBase_BC8 engine) {
        super(manager);
        this.engine = engine;
        this.title = "gui.power";
        this.appendText(LocaleUtil.localize("gui.currentOutput") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMjFlow(engine.currentOutput), -16777216);
        this.appendText(LocaleUtil.localize("gui.stored") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj(engine.getEnergyStored()), -16777216);
        this.appendText(LocaleUtil.localize("gui.heat") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeHeat(engine.getHeat()), -16777216);
        this.calculateMaxSize();
    }

    @Override
    public int getColour() {
        return -2855905;
    }

    @Override
    public int getTitleColour() {
        return -1980113;
    }

    @Override
    protected void drawIcon(int x, int y) {
        SpriteHolderRegistry.SpriteHolder sprite;
        switch (this.engine.getPowerStage()) {
            case OVERHEAT: {
                sprite = BCLibSprites.ENGINE_OVERHEAT;
                break;
            }
            case RED: 
            case YELLOW: {
                sprite = BCLibSprites.ENGINE_WARM;
                break;
            }
            default: {
                sprite = this.engine.isEngineOn() ? BCLibSprites.ENGINE_ACTIVE : BCLibSprites.ENGINE_INACTIVE;
            }
        }
        GuiIcon.draw(sprite, x, y, x + 16, y + 16);
    }
}

