/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.help;

import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.elem.GuiElementContainer;
import buildcraft.lib.gui.elem.GuiElementText;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StringUtilBC;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElementHelpInfo {
    public final String title;
    public final int colour;
    public final String[] localeKeys;

    public ElementHelpInfo(String title, int colour, String ... localeKeys) {
        this.title = title;
        this.colour = colour;
        this.localeKeys = localeKeys;
    }

    @SideOnly(value=Side.CLIENT)
    public final HelpPosition target(IGuiArea target) {
        return new HelpPosition(this, target);
    }

    @SideOnly(value=Side.CLIENT)
    public void addGuiElements(GuiElementContainer container) {
        GuiBC8<?> gui = container.gui;
        int y = 20;
        for (String key : this.localeKeys) {
            if (key == null) {
                y += container.gui.getFontRenderer().field_78288_b + 5;
                continue;
            }
            String localized = LocaleUtil.localize(key);
            List<String> lines = StringUtilBC.splitIntoLines(localized);
            for (String line : lines) {
                GuiElementText elemText = new GuiElementText(gui, (IGuiPosition)container.offset(0, y), line, 0);
                container.add(elemText);
                y += elemText.getHeight() + 5;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class HelpPosition {
        public final ElementHelpInfo info;
        public final IGuiArea target;

        private HelpPosition(ElementHelpInfo info, IGuiArea target) {
            this.info = info;
            this.target = target;
        }
    }
}

