/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StringUtilBC;
import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class ToolTip
extends ForwardingList<String>
implements RandomAccess {
    private final List<String> delegate = new ArrayList<String>();
    private final long delay;
    private long mouseOverStart;

    public static ToolTip createLocalized(String ... localeKeys) {
        ArrayList<String> allLines = new ArrayList<String>();
        for (String key : localeKeys) {
            String localized = LocaleUtil.localize(key);
            allLines.addAll(StringUtilBC.splitIntoLines(localized));
        }
        return new ToolTip(allLines);
    }

    public ToolTip(String ... lines) {
        this.delay = 0L;
        Collections.addAll(this.delegate, lines);
    }

    public ToolTip(int delay, String ... lines) {
        this.delay = delay;
        Collections.addAll(this.delegate, lines);
    }

    private ToolTip(List<String> lines) {
        this.delay = 0L;
        this.delegate.addAll(lines);
    }

    protected final List<String> delegate() {
        return this.delegate;
    }

    public void onTick(boolean mouseOver) {
        if (this.delay == 0L) {
            return;
        }
        if (mouseOver) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
    }

    public boolean isReady() {
        if (this.delay == 0L) {
            return true;
        }
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= this.delay;
    }

    public void refresh() {
    }
}

