/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.MathUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ScrollbarElement<G extends GuiBC8<?>>
extends GuiElementSimple<G> {
    private static final int HEIGHT = 14;
    private final GuiIcon background;
    private final GuiIcon scroller;
    private int pos;
    private int len;
    private boolean isClicking;

    public ScrollbarElement(G gui, IGuiPosition parent, int height, GuiIcon background, GuiIcon scroller) {
        super(gui, parent, new GuiRectangle(0, 0, 6, height));
        this.background = background;
        this.scroller = scroller;
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (this.len > 0) {
            this.background.drawAt(this);
            this.scroller.drawAt(this.offset(0, this.pos * (this.getHeight() - 14 + 2) / this.len));
        }
    }

    private void updatePositionFromMouse() {
        int h = this.getHeight();
        this.setPosition(((this.gui.mouse.getY() - this.getY()) * this.len + h / 2) / h);
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.contains(this.gui.mouse) && button == 0) {
            this.isClicking = true;
            this.updatePositionFromMouse();
        }
    }

    @Override
    public void onMouseDragged(int button, long ticksSinceClick) {
        if (this.isClicking && button == 0) {
            this.updatePositionFromMouse();
        }
    }

    @Override
    public void onMouseReleased(int button) {
        if (this.isClicking && button == 0) {
            this.updatePositionFromMouse();
            this.isClicking = false;
        }
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = MathUtil.clamp(pos, 0, this.len);
    }

    public void setLength(int len) {
        this.len = len;
        this.setPosition(this.pos);
    }
}

