/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiElementText
extends GuiElementSimple<GuiBC8<?>> {
    public boolean dropShadow = false;
    public boolean foreground = true;
    private final Supplier<String> text;
    private final IntSupplier colour;

    public GuiElementText(GuiBC8<?> gui, IGuiPosition parent, Supplier<String> text, IntSupplier colour) {
        super(gui, parent, GuiRectangle.ZERO);
        this.text = text;
        this.colour = colour;
    }

    public GuiElementText(GuiBC8<?> gui, IGuiPosition parent, String text, int colour) {
        this(gui, parent, () -> text, () -> colour);
    }

    public GuiElementText setDropShadow(boolean value) {
        this.dropShadow = value;
        return this;
    }

    public GuiElementText setForeground(boolean value) {
        this.foreground = value;
        return this;
    }

    @Override
    public int getWidth() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.func_78256_a(this.text.get());
    }

    @Override
    public int getHeight() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.field_78288_b;
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (!this.foreground) {
            this.draw();
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        if (this.foreground) {
            this.draw();
        }
    }

    private void draw() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a(this.text.get(), (float)this.getX(), (float)this.getY(), this.colour.getAsInt(), this.dropShadow);
    }
}

