/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GuiElementContainer
implements IGuiElement {
    public final GuiBC8<?> gui;
    private final IGuiPosition position;
    private final List<IGuiElement> internalElements = new ArrayList<IGuiElement>();
    private int width;
    private int height;
    private boolean calc = false;

    public GuiElementContainer(GuiBC8<?> gui, IGuiPosition position) {
        this.gui = gui;
        this.position = position;
    }

    private void recalcSize() {
        this.calc = true;
        this.width = 0;
        this.height = 0;
        int w = 0;
        int h = 0;
        for (IGuiElement element : this.internalElements) {
            w = Math.max(w, element.getEndX());
            h = Math.max(h, element.getEndY());
        }
        this.width = w;
        this.height = h;
        this.calc = false;
    }

    public void add(IGuiElement element) {
        this.internalElements.add(element);
        this.recalcSize();
    }

    public void addAll(IGuiElement ... elements) {
        Collections.addAll(this.internalElements, elements);
        this.recalcSize();
    }

    public void addAll(Collection<IGuiElement> elements) {
        this.internalElements.addAll(elements);
        this.recalcSize();
    }

    @Override
    public int getX() {
        return this.calc ? 0 : this.position.getX();
    }

    @Override
    public int getY() {
        return this.calc ? 0 : this.position.getY();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void drawBackground(float partialTicks) {
        for (IGuiElement element : this.internalElements) {
            element.drawBackground(partialTicks);
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        for (IGuiElement element : this.internalElements) {
            element.drawForeground(partialTicks);
        }
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        for (IGuiElement element : this.internalElements) {
            element.addToolTips(tooltips);
        }
    }
}

