/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.button;

import buildcraft.lib.gui.button.GuiAbstractButton;

public interface IButtonBehaviour {
    public static final IButtonBehaviour DEFAULT = new IButtonBehaviour(){

        @Override
        public void mousePressed(GuiAbstractButton button, int bkey) {
            button.active = true;
        }

        @Override
        public void mouseReleased(GuiAbstractButton button, int bkey) {
            button.active = false;
            if (button.contains(button.gui.mouse)) {
                button.notifyButtonClicked(bkey);
            }
        }
    };
    public static final IButtonBehaviour TOGGLE = new IButtonBehaviour(){

        @Override
        public void mousePressed(GuiAbstractButton button, int bkey) {
            button.active = !button.active;
            button.notifyButtonClicked(bkey);
        }

        @Override
        public void mouseReleased(GuiAbstractButton button, int bkey) {
        }
    };

    public void mousePressed(GuiAbstractButton var1, int var2);

    public void mouseReleased(GuiAbstractButton var1, int var2);

    public static Radio createAndSetRadioButtons(GuiAbstractButton ... buttons) {
        Radio radio = new Radio(buttons);
        for (GuiAbstractButton button : buttons) {
            button.setBehaviour(radio);
        }
        return radio;
    }

    public static class Radio
    implements IButtonBehaviour {
        public final GuiAbstractButton[] buttons;

        public Radio(GuiAbstractButton ... buttons) {
            this.buttons = buttons;
        }

        @Override
        public void mousePressed(GuiAbstractButton button, int bkey) {
            for (GuiAbstractButton toDisable : this.buttons) {
                if (toDisable == button) {
                    if (button.active) continue;
                    button.active = true;
                    continue;
                }
                toDisable.active = false;
            }
        }

        @Override
        public void mouseReleased(GuiAbstractButton button, int bkey) {
            if (button.contains(button.gui.mouse)) {
                button.notifyButtonClicked(bkey);
            }
        }
    }
}

