/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.button;

import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.button.IButtonClickEventListener;
import buildcraft.lib.gui.button.IButtonClickEventTrigger;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public abstract class GuiAbstractButton
extends GuiButton
implements IGuiElement,
IButtonClickEventTrigger {
    public final GuiBC8<?> gui;
    private final List<IButtonClickEventListener> listeners = new ArrayList<IButtonClickEventListener>();
    public boolean active = false;
    private IButtonBehaviour behaviour = IButtonBehaviour.DEFAULT;
    private ToolTip toolTip;

    public GuiAbstractButton(GuiBC8<?> gui, int buttonId, int x, int y, String buttonText) {
        super(buttonId, x, y, buttonText);
        this.gui = gui;
    }

    public GuiAbstractButton(GuiBC8<?> gui, int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.gui = gui;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deActivate() {
        this.active = false;
    }

    public GuiAbstractButton setActive(boolean active) {
        this.active = active;
        return this;
    }

    public boolean func_146115_a() {
        return this.getGuiRectangle().contains(this.gui.mouse);
    }

    protected int func_146114_a(boolean mouseOver) {
        if (!this.field_146124_l) {
            return 0;
        }
        return mouseOver ? (this.active ? 2 : 4) : (this.active ? 1 : 3);
    }

    public GuiAbstractButton setBehaviour(IButtonBehaviour behaviour) {
        this.behaviour = behaviour;
        return this;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.onMouseClicked(0);
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.onMouseReleased(0);
    }

    public GuiAbstractButton setToolTip(ToolTip tips) {
        this.toolTip = tips;
        return this;
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        if (this.field_146125_m && this.toolTip != null && this.func_146115_a()) {
            tooltips.add(this.toolTip);
        }
    }

    @Override
    public void notifyButtonClicked(int bkey) {
        for (IButtonClickEventListener listener : this.listeners) {
            listener.handleButtonClick(this, this.field_146127_k, bkey);
        }
    }

    @Override
    public GuiAbstractButton registerListener(IButtonClickEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public GuiAbstractButton removeListener(IButtonClickEventListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public boolean isButtonActive() {
        return this.active;
    }

    @Override
    public int getX() {
        return this.field_146128_h;
    }

    @Override
    public int getY() {
        return this.field_146129_i;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g;
    }

    public GuiRectangle getGuiRectangle() {
        return this.asImmutable();
    }

    @Override
    public final void drawBackground(float partialTicks) {
        this.func_146112_a(this.gui.field_146297_k, this.gui.mouse.getX(), this.gui.mouse.getY());
    }

    @Override
    public final void drawForeground(float partialTicks) {
        this.func_146111_b(this.gui.mouse.getX(), this.gui.mouse.getY());
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.contains(this.gui.mouse)) {
            this.behaviour.mousePressed(this, button);
        }
    }

    @Override
    public void onMouseReleased(int button) {
        this.behaviour.mouseReleased(this, button);
    }
}

