/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.ITooltipElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.misc.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;

public class GuiElementToolTips
implements IGuiElement {
    private final GuiBC8<?> gui;

    public GuiElementToolTips(GuiBC8<?> gui) {
        this.gui = gui;
    }

    @Override
    public int getX() {
        return this.gui.mouse.getX();
    }

    @Override
    public int getY() {
        return this.gui.mouse.getY();
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public void drawForeground(float partialTicks) {
        ArrayList<ToolTip> tooltips = new ArrayList<ToolTip>();
        if (this.gui instanceof ITooltipElement) {
            GuiElementToolTips.checkAndAddTooltip(tooltips, (ITooltipElement)((Object)this.gui));
        }
        for (IGuiElement elem : this.gui.guiElements) {
            GuiElementToolTips.checkAndAddTooltip(tooltips, elem);
        }
        GuiElementToolTips.checkAndAddTooltip(tooltips, this.gui.ledgersLeft);
        GuiElementToolTips.checkAndAddTooltip(tooltips, this.gui.ledgersRight);
        for (GuiButton button : this.gui.getButtonList()) {
            if (!(button instanceof ITooltipElement)) continue;
            GuiElementToolTips.checkAndAddTooltip(tooltips, (ITooltipElement)button);
        }
        GuiUtil.drawVerticallyAppending(this, tooltips, this::drawTooltip);
    }

    private static void checkAndAddTooltip(List<ToolTip> tooltips, ITooltipElement elem) {
        elem.addToolTips(tooltips);
    }

    private int drawTooltip(ToolTip tooltip, int x, int y) {
        return 4 + GuiUtil.drawHoveringText((List<String>)((Object)tooltip), x, y, this.gui.field_146294_l, this.gui.field_146295_m, -1, this.gui.field_146297_k.field_71466_p);
    }
}

