/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.lib.BCLibSprites;
import buildcraft.lib.gui.ContainerBCTile;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiElementToolTips;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.GuiSpriteScaled;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.ledger.LedgerHelp;
import buildcraft.lib.gui.ledger.LedgerManager_Neptune;
import buildcraft.lib.gui.ledger.LedgerOwnership;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.MousePosition;
import buildcraft.lib.gui.pos.PositionCallable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public abstract class GuiBC8<C extends ContainerBC_Neptune>
extends GuiContainer {
    public static boolean debugging = false;
    public static final GuiSpriteScaled SPRITE_DEBUG = new GuiSpriteScaled(BCLibSprites.DEBUG, 16, 16);
    public final C container;
    public final MousePosition mouse = new MousePosition();
    public final RootPosition rootElement = new RootPosition(this);
    public final List<IGuiElement> guiElements = new ArrayList<IGuiElement>();
    public final LedgerManager_Neptune ledgersLeft;
    public final LedgerManager_Neptune ledgersRight;
    protected final LedgerHelp ledgerHelp;
    private final GuiElementToolTips tooltips = new GuiElementToolTips(this);
    private float lastPartialTicks;

    public GuiBC8(C container) {
        super(container);
        this.container = container;
        this.ledgersLeft = new LedgerManager_Neptune(this, this.rootElement.offset(0, 5), false);
        IGuiArea rightPos = this.rootElement.offset(new PositionCallable(this.rootElement::getWidth, 5));
        this.ledgersRight = new LedgerManager_Neptune(this, rightPos, true);
        if (container instanceof ContainerBCTile) {
            this.ledgersRight.ledgers.add(new LedgerOwnership(this.ledgersRight, (ContainerBCTile)((Object)container)));
        }
        if (this.shouldAddHelpLedger()) {
            this.ledgerHelp = new LedgerHelp(this.ledgersLeft);
            this.ledgersLeft.ledgers.add(this.ledgerHelp);
        } else {
            this.ledgerHelp = null;
        }
    }

    protected boolean shouldAddHelpLedger() {
        return true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiElements.clear();
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public float getLastPartialTicks() {
        return this.lastPartialTicks;
    }

    public Stream<IGuiElement> getElementAt(int x, int y) {
        return this.guiElements.stream().filter(elem -> elem.contains(x, y));
    }

    public void drawItemStackAt(ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, stack, x, y);
        this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, stack, x, y, null);
        RenderHelper.func_74518_a();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.ledgersLeft.update();
        this.ledgersRight.update();
    }

    protected final void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SPRITE_DEBUG.drawAt(0, 0);
        if (debugging) {
            GuiBC8.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)0x33FFFFFF);
            int w = 320;
            int h = 240;
            int sx = (this.field_146294_l - w) / 2;
            int sy = (this.field_146295_m - h) / 2;
            int ex = sx + w + 1;
            int ey = sy + h + 1;
            GuiBC8.func_73734_a((int)(--sx), (int)(--sy), (int)(ex + 1), (int)(sy + 1), (int)-1);
            GuiBC8.func_73734_a((int)sx, (int)ey, (int)(ex + 1), (int)(ey + 1), (int)-1);
            GuiBC8.func_73734_a((int)sx, (int)sy, (int)(sx + 1), (int)(ey + 1), (int)-1);
            GuiBC8.func_73734_a((int)ex, (int)sy, (int)(ex + 1), (int)(ey + 1), (int)-1);
        }
        RenderHelper.func_74518_a();
        this.lastPartialTicks = partialTicks;
        this.mouse.setMousePosition(mouseX, mouseY);
        this.drawBackgroundLayer(partialTicks);
        for (IGuiElement element : this.guiElements) {
            element.drawBackground(partialTicks);
        }
        this.ledgersLeft.drawBackground(partialTicks);
        this.ledgersRight.drawBackground(partialTicks);
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.mouse.setMousePosition(mouseX, mouseY);
        this.drawForegroundLayer();
        for (IGuiElement element : this.guiElements) {
            element.drawForeground(this.lastPartialTicks);
        }
        this.ledgersLeft.drawForeground(this.lastPartialTicks);
        this.ledgersRight.drawForeground(this.lastPartialTicks);
        this.tooltips.drawForeground(this.lastPartialTicks);
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
    }

    public void drawProgress(GuiRectangle rect, GuiIcon icon, double widthPercent, double heightPercent) {
        int nWidth = MathHelper.func_76143_f((double)((double)rect.width * Math.abs(widthPercent)));
        int nHeight = MathHelper.func_76143_f((double)((double)rect.height * Math.abs(heightPercent)));
        icon.offset(widthPercent > 0.0 ? 0 : rect.width - nWidth, heightPercent > 0.0 ? 0 : rect.height - nHeight).drawCutInside(new GuiRectangle(widthPercent > 0.0 ? rect.x : rect.x + (rect.width - nWidth), heightPercent > 0.0 ? rect.y : rect.y + (rect.height - nHeight), nWidth, nHeight).offset(this.rootElement));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.mouse.setMousePosition(mouseX, mouseY);
        GuiRectangle debugRect = new GuiRectangle(0, 0, 16, 16);
        if (debugRect.contains(this.mouse)) {
            debugging = !debugging;
        }
        for (IGuiElement element : this.guiElements) {
            element.onMouseClicked(mouseButton);
        }
        this.ledgersLeft.onMouseClicked(mouseButton);
        this.ledgersRight.onMouseClicked(mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.mouse.setMousePosition(mouseX, mouseY);
        for (IGuiElement element : this.guiElements) {
            element.onMouseDragged(clickedMouseButton, timeSinceLastClick);
        }
        this.ledgersLeft.onMouseDragged(clickedMouseButton, timeSinceLastClick);
        this.ledgersRight.onMouseDragged(clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.mouse.setMousePosition(mouseX, mouseY);
        for (IGuiElement element : this.guiElements) {
            element.onMouseReleased(state);
        }
        this.ledgersLeft.onMouseReleased(state);
        this.ledgersRight.onMouseReleased(state);
    }

    protected void drawBackgroundLayer(float partialTicks) {
    }

    protected void drawForegroundLayer() {
    }

    public static final class RootPosition
    implements IGuiArea {
        public final GuiBC8<?> gui;

        public RootPosition(GuiBC8<?> gui) {
            this.gui = gui;
        }

        @Override
        public int getX() {
            return ((GuiBC8)this.gui).field_147003_i;
        }

        @Override
        public int getY() {
            return ((GuiBC8)this.gui).field_147009_r;
        }

        @Override
        public int getWidth() {
            return ((GuiBC8)this.gui).field_146999_f;
        }

        @Override
        public int getHeight() {
            return ((GuiBC8)this.gui).field_147000_g;
        }
    }
}

