/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.gui.Widget_Neptune;
import buildcraft.lib.gui.slot.IPhantomSlot;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.MessageContainer;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class ContainerBC_Neptune
extends Container {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.container");
    protected static final IdAllocator IDS = new IdAllocator("container");
    public static final int NET_DATA = IDS.allocId("DATA");
    public static final int NET_WIDGET = IDS.allocId("WIDGET");
    public final EntityPlayer player;
    private final List<Widget_Neptune<?>> widgets = new ArrayList();

    public ContainerBC_Neptune(EntityPlayer player) {
        this.player = player;
    }

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    protected void addFullPlayerInventory(int startX, int startY) {
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 9; ++sx) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, sx + sy * 9 + 9, startX + sx * 18, startY + sy * 18));
            }
        }
        for (int sx = 0; sx < 9; ++sx) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, sx, startX + sx * 18, startY + 58));
        }
    }

    protected void addFullPlayerInventory(int startY) {
        this.addFullPlayerInventory(8, startY);
    }

    protected <W extends Widget_Neptune<?>> W addWidget(W widget) {
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        this.widgets.add(widget);
        return widget;
    }

    public ImmutableList<Widget_Neptune<?>> getWidgets() {
        return ImmutableList.copyOf(this.widgets);
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot == null) {
            return super.func_184996_a(slotId, dragType, clickType, player);
        }
        ItemStack playerStack = player.field_71071_by.func_70445_o();
        if (slot instanceof IPhantomSlot) {
            ItemStack stack;
            IPhantomSlot phantom = (IPhantomSlot)slot;
            if (playerStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (!StackUtil.canMerge(playerStack, StackUtil.asNonNull(slot.func_75211_c()))) {
                ItemStack copy = playerStack.func_77946_l();
                copy.func_190920_e(1);
                slot.func_75215_d(copy);
            } else if (phantom.canAdjustCount() && (stack = slot.func_75211_c()).func_190916_E() < stack.func_77976_d()) {
                stack.func_190917_f(1);
                slot.func_75215_d(stack);
            }
            return playerStack;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        Slot firstSlot = (Slot)this.field_75151_b.get(0);
        int playerInventorySize = 36;
        boolean playerInventoryFirst = firstSlot.field_75224_c instanceof InventoryPlayer;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.field_75151_b.size() == playerInventorySize) {
                return ItemStack.field_190927_a;
            }
            if (playerInventoryFirst ? (index < playerInventorySize ? !this.func_75135_a(itemstack1, playerInventorySize, this.field_75151_b.size(), false) : !this.func_75135_a(itemstack1, 0, playerInventorySize, true)) : (index < this.field_75151_b.size() - playerInventorySize ? !this.func_75135_a(itemstack1, this.field_75151_b.size() - playerInventorySize, this.field_75151_b.size(), false) : !this.func_75135_a(itemstack1, 0, this.field_75151_b.size() - playerInventorySize, true))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public static ItemStack safeCopy(ItemStack in) {
        return in == null ? null : in.func_77946_l();
    }

    void sendWidgetData(Widget_Neptune<?> widget, IPayloadWriter writer) {
        int widgetId = this.widgets.indexOf(widget);
        if (widgetId == -1) {
            if (DEBUG) {
                throw new IllegalArgumentException("Invalid Widget Request! (" + (widget == null ? "null" : widget.getClass()) + ")");
            }
            BCLog.logger.warn("[lib.container] Received an invalid widget sending request!");
            BCLog.logger.warn("[lib.container]   Widget {id = " + widgetId + ", class = " + widget.getClass() + "}");
            BCLog.logger.warn("[lib.container]   Container {class = " + ((Object)((Object)this)).getClass() + "}");
            BCLog.logger.warn("[lib.container]   Player {class = " + this.player.getClass() + ", name = " + this.player.func_70005_c_() + "}");
        } else {
            this.sendMessage(NET_WIDGET, buffer -> {
                buffer.writeShort(widgetId);
                writer.write(buffer);
            });
        }
    }

    public final void sendMessage(int id) {
        Side side = this.player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        this.sendMessage(id, buffer -> this.writeMessage(id, buffer, side));
    }

    public final void sendMessage(int id, IPayloadWriter writer) {
        PacketBufferBC payload = PacketBufferBC.write(writer);
        MessageContainer message = new MessageContainer(this.field_75152_c, id, payload);
        if (this.player.field_70170_p.field_72995_K) {
            MessageManager.sendToServer(message);
        } else {
            MessageManager.sendTo(message, (EntityPlayerMP)this.player);
        }
    }

    public void writeMessage(int id, PacketBufferBC buffer, Side side) {
    }

    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (id == NET_WIDGET) {
            int widgetId = buffer.readUnsignedShort();
            if (widgetId < 0 || widgetId >= this.widgets.size()) {
                if (DEBUG) {
                    String string = "Received unknown or invalid widget ID " + widgetId + " on side " + side;
                    if (side == Side.SERVER) {
                        string = string + " (for player " + this.player.func_70005_c_() + ")";
                    }
                    BCLog.logger.warn(string);
                }
            } else {
                Widget_Neptune<?> widget = this.widgets.get(widgetId);
                if (side == Side.SERVER) {
                    widget.handleWidgetDataServer(ctx, buffer);
                } else if (side == Side.CLIENT) {
                    widget.handleWidgetDataClient(ctx, buffer);
                }
            }
        }
    }
}

