/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class Tank
extends FluidTank
implements IFluidHandlerAdv {
    public static final String DEFAULT_HELP_KEY = "buildcraft.help.tank.generic";
    public int colorRenderCache = 0xFFFFFF;
    protected final ToolTip toolTip = new ToolTip(new String[0]){

        @Override
        public void refresh() {
            Tank.this.refreshTooltip();
        }
    };
    @Nonnull
    private final String name;
    @Nonnull
    private final Predicate<FluidStack> filter;
    NetworkedObjectCache.Link clientFluid = null;
    int clientAmount = 0;
    public ElementHelpInfo helpInfo;
    protected static Map<Fluid, Integer> fluidColors = new HashMap<Fluid, Integer>();

    public Tank(@Nonnull String name, int capacity, TileEntity tile) {
        this(name, capacity, tile, null);
    }

    public Tank(@Nonnull String name, int capacity, TileEntity tile, @Nullable Predicate<FluidStack> filter) {
        super(capacity);
        this.name = name;
        this.tile = tile;
        this.filter = filter == null ? f -> true : filter;
        this.helpInfo = new ElementHelpInfo("buildcraft.help.tank.title." + name, 0xFF000000 | name.hashCode(), DEFAULT_HELP_KEY);
    }

    @Nonnull
    public String getTankName() {
        return this.name;
    }

    public boolean isEmpty() {
        FluidStack fluidStack = this.getFluid();
        return fluidStack == null || fluidStack.amount <= 0;
    }

    public boolean isFull() {
        FluidStack fluidStack = this.getFluid();
        return fluidStack != null && fluidStack.amount >= this.getCapacity();
    }

    public Fluid getFluidType() {
        FluidStack fluidStack = this.getFluid();
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.writeTankToNBT(nbt);
        return nbt;
    }

    public final FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.name)) {
            NBTTagCompound tankData = nbt.func_74775_l(this.name);
            super.readFromNBT(tankData);
            this.readTankFromNBT(tankData);
        } else {
            super.readFromNBT(nbt);
            this.readTankFromNBT(nbt);
        }
        return this;
    }

    public void writeTankToNBT(NBTTagCompound nbt) {
    }

    public void readTankFromNBT(NBTTagCompound nbt) {
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected void refreshTooltip() {
        FluidStack fluidStack;
        this.toolTip.clear();
        int amount = this.clientAmount;
        FluidStack fluidStack2 = fluidStack = this.clientFluid == null ? null : ((FluidStack)this.clientFluid.get()).copy();
        if (fluidStack != null && amount > 0) {
            this.toolTip.add(LocaleUtil.localizeFluidStatic(new FluidStack(fluidStack, amount), this.getCapacity()));
        } else {
            this.toolTip.add(LocaleUtil.localizeFluidStatic(null, this.getCapacity()));
        }
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return super.canFillFluidType(fluid) && fluid != null && this.filter.test(fluid);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.canFillFluidType(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(IFluidFilter drainFilter, int maxDrain, boolean doDrain) {
        if (drainFilter == null) {
            return null;
        }
        if (drainFilter.matches(this.getFluid())) {
            return this.drain(maxDrain, doDrain);
        }
        return null;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid == null || this.filter.test(fluid)) {
            super.setFluid(fluid);
        }
    }

    public String toString() {
        return "Tank [" + this.getContentsString() + "]";
    }

    public String getContentsString() {
        return LocaleUtil.localizeFluidStatic(this.fluid, this.capacity);
    }

    public void writeToBuffer(PacketBufferBC buffer) {
        if (this.fluid == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeInt(BuildCraftObjectCaches.CACHE_FLUIDS.server().store(this.fluid));
        }
        buffer.writeInt(this.getFluidAmount());
    }

    public void readFromBuffer(PacketBufferBC buffer) {
        this.clientFluid = buffer.readBoolean() ? BuildCraftObjectCaches.CACHE_FLUIDS.client().retrieve(buffer.readInt()) : null;
        this.clientAmount = buffer.readInt();
    }

    public FluidStack getFluidForRender() {
        if (this.clientFluid == null) {
            return null;
        }
        FluidStack stackBase = (FluidStack)this.clientFluid.get();
        return new FluidStack(stackBase, this.clientAmount);
    }

    public int getClientAmount() {
        return this.clientAmount;
    }

    public String getDebugString() {
        FluidStack f = this.getFluidForRender();
        if (f == null) {
            f = this.getFluid();
        }
        return (f == null ? 0 : f.amount) + " / " + this.capacity + " mB of " + (f != null ? f.getFluid().getName() : "n/a");
    }

    public void onGuiClicked(ContainerBC_Neptune container) {
        IFluidHandlerItem fluidHandler;
        EntityPlayer player = container.player;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (held.func_190926_b()) {
            return;
        }
        boolean hasFilled = false;
        ItemStack copy = held.func_77946_l();
        copy.func_190920_e(1);
        int space = this.capacity - this.getFluidAmount();
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        boolean isSurvival = !isCreative;
        FluidGetResult result = this.map(copy, space);
        if (result != null && result.fluidStack != null && result.fluidStack.amount > 0) {
            if (isCreative) {
                held = copy;
            }
            int potential = held.func_190916_E();
            for (int p = 0; p < potential; ++p) {
                int accepted = this.fill(result.fluidStack, false);
                if (!(isCreative ? accepted > 0 : accepted == result.fluidStack.amount)) break;
                hasFilled = true;
                int reallyAccepted = this.fill(result.fluidStack, true);
                if (reallyAccepted != accepted) {
                    throw new IllegalStateException("We seem to be buggy! (accepted = " + accepted + ", reallyAccepted = " + reallyAccepted + ")");
                }
                held.func_190918_g(1);
                if (isSurvival) {
                    if (held.func_190926_b()) {
                        held = result.itemStack;
                        break;
                    }
                    if (result.itemStack.func_190926_b()) continue;
                    player.field_71071_by.func_70441_a(result.itemStack);
                    player.field_71069_bz.func_75142_b();
                    continue;
                }
                if (held.func_190926_b()) break;
            }
            if (isSurvival) {
                player.field_71071_by.func_70437_b(held.func_190926_b() ? StackUtil.EMPTY : held);
                ((EntityPlayerMP)player).func_71113_k();
            }
            if (hasFilled) {
                FluidStack fl = this.getFluid();
                if (fl != null) {
                    SoundUtil.playBucketEmpty(player.field_70170_p, player.func_180425_c(), fl);
                }
                return;
            }
        }
        if ((fluidHandler = FluidUtil.getFluidHandler((ItemStack)held.func_77946_l())) == null) {
            return;
        }
        FluidStack drained = this.drain(this.capacity, false);
        if (drained == null || drained.amount <= 0) {
            return;
        }
        int filled = fluidHandler.fill(drained, true);
        if (filled > 0) {
            FluidStack reallyDrained = this.drain(filled, true);
            if (reallyDrained == null || reallyDrained.amount != filled) {
                throw new IllegalStateException("Somehow drained differently than expected! ( drained = " + drained + ", filled = " + filled + ", reallyDrained = " + reallyDrained + " )");
            }
            if (isSurvival) {
                ItemStack filledContainer = fluidHandler.getContainer();
                player.field_71071_by.func_70437_b(filledContainer);
                ((EntityPlayerMP)player).func_71113_k();
            }
            SoundUtil.playBucketFill(player.field_70170_p, player.func_180425_c(), reallyDrained);
        }
    }

    protected FluidGetResult map(ItemStack stack, int space) {
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l());
        if (fluidHandler == null) {
            return null;
        }
        FluidStack drained = fluidHandler.drain(space, true);
        if (drained == null || drained.amount <= 0) {
            return null;
        }
        ItemStack leftOverStack = fluidHandler.getContainer();
        if (leftOverStack.func_190926_b()) {
            leftOverStack = StackUtil.EMPTY;
        }
        return new FluidGetResult(leftOverStack, drained);
    }

    public static class FluidGetResult {
        public final ItemStack itemStack;
        public final FluidStack fluidStack;

        public FluidGetResult(ItemStack itemStack, FluidStack fluidStack) {
            this.itemStack = itemStack;
            this.fluidStack = fluidStack;
        }
    }
}

