/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidSmoother
implements IDebuggable {
    final IFluidDataSender sender;
    final Tank tank;
    _Side data;

    public FluidSmoother(IFluidDataSender sender, Tank tank) {
        this.sender = sender;
        this.tank = tank;
    }

    public void tick(World world) {
        if (this.data == null) {
            if (world == null) {
                return;
            }
            this.data = world.field_72995_K ? new _Client() : new _Server();
        }
        this.data.tick(world);
    }

    public void handleMessage(World world, PacketBufferBC buffer) {
        if (this.data == null) {
            this.data = new _Client();
        }
        if (!(this.data instanceof _Client)) {
            throw new IllegalStateException("You can only call this on the client!");
        }
        ((_Client)this.data).handleMessage(world, buffer);
    }

    public void writeInit(PacketBufferBC buffer) {
        if (this.data == null) {
            this.data = new _Server();
        }
        if (!(this.data instanceof _Server)) {
            throw new IllegalStateException("You can only call this on the client!");
        }
        ((_Server)this.data).writeMessage(buffer);
    }

    public void resetSmoothing(World world) {
        if (this.data == null && world.field_72995_K) {
            this.data = new _Client();
        }
        if (!(this.data instanceof _Client)) {
            throw new IllegalStateException("You can only call this on the client!");
        }
        _Client client = (_Client)this.data;
        client.resetSmoothing(world);
    }

    public FluidStack getFluidForRender() {
        if (this.data instanceof _Client) {
            _Client client = (_Client)this.data;
            if (client.link == null) {
                return null;
            }
            FluidStack fluid = (FluidStack)client.link.get();
            if (fluid == null) {
                return null;
            }
            return new FluidStack(fluid, client.amount);
        }
        return null;
    }

    public FluidStackInterp getFluidForRender(double partialTicks) {
        if (this.data instanceof _Client) {
            _Client client = (_Client)this.data;
            if (client.link == null) {
                return null;
            }
            FluidStack fluid = (FluidStack)client.link.get();
            if (fluid == null) {
                return null;
            }
            double amount = (double)client.amountLast * (1.0 - partialTicks) + (double)client.amount * partialTicks;
            return new FluidStackInterp(fluid, amount);
        }
        return null;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        if (this.data != null) {
            this.data.getDebugInfo(left, right, side);
        }
    }

    final class _Client
    extends _Side {
        private int target;
        int amount;
        int amountLast;
        long lastMessage;
        long lastMessageMinus1;
        NetworkedObjectCache.Link link;

        _Client() {
        }

        @Override
        void tick(World world) {
            this.amountLast = this.amount;
            if (this.amount != this.target) {
                int delta = this.target - this.amount;
                long msgDelta = this.lastMessage - this.lastMessageMinus1;
                msgDelta = MathUtil.clamp((int)msgDelta, 1, 60);
                this.amount = (long)Math.abs(delta) < msgDelta ? (this.amount += delta) : (this.amount += delta / (int)msgDelta);
            }
        }

        void handleMessage(World world, PacketBufferBC buffer) {
            this.target = buffer.readInt();
            if (buffer.readBoolean()) {
                this.link = BuildCraftObjectCaches.CACHE_FLUIDS.client().retrieve(buffer.readInt());
            }
            this.lastMessageMinus1 = this.lastMessage;
            this.lastMessage = world.func_82737_E();
        }

        void resetSmoothing(World world) {
            this.lastMessageMinus1 = this.lastMessage = world.func_82737_E();
            --this.lastMessageMinus1;
        }

        @Override
        public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
            left.add("shown = " + this.amount + ", target = " + this.target);
            left.add("lastMsg = " + this.lastMessage + ", lastMsg-1 = " + this.lastMessageMinus1 + ", diff = " + (this.lastMessage - this.lastMessageMinus1));
        }
    }

    final class _Server
    extends _Side {
        private int sentAmount;
        private boolean sentHasFluid;
        private final SafeTimeTracker tracker;

        _Server() {
            this.sentAmount = -1;
            this.sentHasFluid = false;
            this.tracker = new SafeTimeTracker(BCCoreConfig.networkUpdateRate, 4L);
        }

        @Override
        void tick(World world) {
            boolean hasFluid;
            FluidStack fluid = FluidSmoother.this.tank.getFluid();
            boolean bl = hasFluid = fluid != null;
            if ((FluidSmoother.this.tank.getFluidAmount() != this.sentAmount || hasFluid != this.sentHasFluid) && this.tracker.markTimeIfDelay(world)) {
                FluidSmoother.this.sender.writePacket(this::writeMessage);
            }
        }

        void writeMessage(PacketBufferBC buffer) {
            FluidStack fluid = FluidSmoother.this.tank.getFluid();
            boolean hasFluid = fluid != null;
            this.sentAmount = FluidSmoother.this.tank.getFluidAmount();
            this.sentHasFluid = hasFluid;
            int amount = this.sentAmount;
            int flId = hasFluid ? BuildCraftObjectCaches.CACHE_FLUIDS.server().store(fluid) : -1;
            buffer.writeInt(amount);
            if (hasFluid) {
                buffer.writeBoolean(true);
                buffer.writeInt(flId);
            } else {
                buffer.writeBoolean(false);
            }
        }

        @Override
        public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
            String contents = FluidSmoother.this.tank.getFluid() != null ? "Something" : "Nothing";
            left.add("current = " + FluidSmoother.this.tank.getFluidAmount() + " of " + contents);
            left.add("lastSent = " + this.sentAmount + " of " + (this.sentHasFluid ? "Something" : "Nothing"));
        }
    }

    abstract class _Side
    implements IDebuggable {
        _Side() {
        }

        abstract void tick(World var1);
    }

    public static class FluidStackInterp {
        public final FluidStack fluid;
        public final double amount;

        public FluidStackInterp(FluidStack fluid, double amount) {
            this.fluid = fluid;
            this.amount = amount;
        }
    }

    @FunctionalInterface
    public static interface IFluidDataSender {
        public void writePacket(IPayloadWriter var1);
    }
}

