/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.lib.BCLibProxy;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.fluid.BCFluidBlock;
import buildcraft.lib.fluid.BCMaterialFluid;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidManager {
    public static <F extends BCFluid> F register(F fluid) {
        return FluidManager.register(fluid, false);
    }

    public static <F extends BCFluid> F register(F fluid, boolean force) {
        if (!force) {
            // empty if block
        }
        FluidRegistry.registerFluid(fluid);
        BCMaterialFluid material = new BCMaterialFluid(fluid.getMapColour(), fluid.isFlammable());
        BCFluidBlock block = new BCFluidBlock(fluid, (Material)material);
        block.setRegistryName(Loader.instance().activeModContainer().getModId(), "fluid_block_" + fluid.getBlockName());
        block.func_149663_c("blockFluid_" + fluid.getBlockName());
        block.func_149713_g(fluid.getLightOpacity());
        GameRegistry.register((IForgeRegistryEntry)block);
        fluid.setBlock((Block)block);
        FluidRegistry.addBucketForFluid(fluid);
        BCLibProxy.getProxy().postRegisterFluid(fluid);
        return fluid;
    }

    @SideOnly(value=Side.CLIENT)
    public static void postRegisterFluid(BCFluid fluid) {
        ModelResourceLocation modelLocation = new ModelResourceLocation(Loader.instance().activeModContainer().getModId() + ":fluid_" + fluid.getName());
        Item item = ItemBlock.func_150898_a((Block)fluid.getBlock());
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelLocation);
        ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
    }
}

