/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.value;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.node.value.NodeConstantDouble;

public class NodeVariableDouble
implements IVariableNode.IVariableNodeDouble {
    public final String name;
    public double value;
    private boolean isConst = false;

    public NodeVariableDouble(String name) {
        this.name = name;
    }

    @Override
    public void setConstant(boolean isConst) {
        this.isConst = isConst;
    }

    @Override
    public double evaluate() {
        return this.value;
    }

    @Override
    public IExpressionNode.INodeDouble inline() {
        if (this.isConst) {
            return new NodeConstantDouble(this.value);
        }
        return this;
    }

    @Override
    public void set(IExpressionNode from) {
        this.value = ((IExpressionNode.INodeDouble)from).evaluate();
    }

    public String toString() {
        return this.name + " = " + this.valueToString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String valueToString() {
        double strVal = this.value * 1000.0;
        strVal = (double)Math.round(strVal) / 1000.0;
        return Double.toString(strVal);
    }
}

