/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.value;

import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.NodeStack;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.node.binary.BiNodeType;
import buildcraft.lib.expression.node.cast.NodeCastLongToDouble;
import buildcraft.lib.expression.node.value.ITickableNode;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeVariableDouble;

public class NodeStateful
implements ITickableNode.Source {
    public final String name;
    public final IVariableNode getter;
    public final IVariableNode variable;
    public final IVariableNode last;
    public final IVariableNode rounderValue;
    final IExpressionNode getterReal;
    final NodeType nodeType;
    private IExpressionNode source;
    private IExpressionNode rounder;

    public NodeStateful(String name, NodeType nodeType, IGetterFunc func) throws InvalidExpressionException {
        this.name = name;
        this.nodeType = nodeType;
        this.variable = nodeType.makeVariableNode(name);
        this.last = nodeType.makeVariableNode(name);
        this.rounderValue = nodeType.makeVariableNode(name);
        this.getter = nodeType.makeVariableNode(name);
        this.getterReal = func.createGetter(this.variable, this.last);
    }

    @Override
    public void setSource(IExpressionNode source) {
        this.source = source;
    }

    public void setRounder(IExpressionNode rounder) throws InvalidExpressionException {
        this.rounder = this.nodeType.cast(rounder);
    }

    @Override
    public Instance createTickable() {
        if (this.source == null) {
            throw new IllegalStateException("source has not been set yet!");
        }
        return new Instance();
    }

    public static enum GetterType implements IGetterFunc
    {
        USE_VAR{

            @Override
            public IExpressionNode createGetter(IVariableNode variable, IVariableNode last) throws InvalidExpressionException {
                return variable;
            }
        }
        ,
        USE_LAST{

            @Override
            public IExpressionNode createGetter(IVariableNode variable, IVariableNode last) throws InvalidExpressionException {
                return last;
            }
        }
        ,
        INTERPOLATE_PARTIAL_TICKS{

            @Override
            public IExpressionNode createGetter(IVariableNode variable, IVariableNode last) throws InvalidExpressionException {
                NodeType type = NodeType.getType(variable);
                switch (type) {
                    case DOUBLE: {
                        IExpressionNode.INodeDouble v = (IExpressionNode.INodeDouble)((Object)variable);
                        IExpressionNode.INodeDouble l = (IExpressionNode.INodeDouble)((Object)last);
                        NodeVariableDouble p = DefaultContexts.RENDER_PARTIAL_TICKS;
                        IExpressionNode.INodeDouble _1_minus_p = BiNodeType.SUB.createDoubleNode(NodeConstantDouble.ONE, p);
                        IExpressionNode.INodeDouble l_times_1_minus_p = BiNodeType.MUL.createDoubleNode(l, _1_minus_p);
                        IExpressionNode.INodeDouble v_times_p = BiNodeType.MUL.createDoubleNode(v, p);
                        return BiNodeType.ADD.createDoubleNode(l_times_1_minus_p, v_times_p);
                    }
                    case LONG: {
                        IExpressionNode.INodeLong v = (IExpressionNode.INodeLong)((Object)variable);
                        IExpressionNode.INodeLong l = (IExpressionNode.INodeLong)((Object)last);
                        NodeVariableDouble p = DefaultContexts.RENDER_PARTIAL_TICKS;
                        IExpressionNode.INodeLong d = BiNodeType.SUB.createLongNode(l, v);
                        NodeCastLongToDouble d_as_double = new NodeCastLongToDouble(d);
                        IExpressionNode.INodeDouble d_times_p = BiNodeType.MUL.createDoubleNode(d_as_double, p);
                        NodeStack stack = new NodeStack(d_times_p);
                        IExpressionNode.INodeLong round_d_times_p = DefaultContexts.MATH_SCALAR_FUNC_ROUND.getNode(stack);
                        return BiNodeType.ADD.createLongNode(l, round_d_times_p);
                    }
                }
                throw new InvalidExpressionException("Cannot create an interpolated value for " + (Object)((Object)type));
            }
        };

    }

    public class Instance
    implements ITickableNode {
        public final IVariableNode storedVar;
        public final IVariableNode storedLast;

        private Instance() {
            this.storedVar = NodeStateful.this.nodeType.makeVariableNode(NodeStateful.this.name);
            this.storedLast = NodeStateful.this.nodeType.makeVariableNode(NodeStateful.this.name);
        }

        public NodeStateful getContainer() {
            return NodeStateful.this;
        }

        @Override
        public void refresh() {
            NodeStateful.this.last.set(this.storedLast);
            NodeStateful.this.variable.set(this.storedVar);
            NodeStateful.this.getter.set(NodeStateful.this.getterReal);
        }

        @Override
        public void tick() {
            this.refresh();
            this.storedLast.set(this.storedVar);
            this.storedVar.set(NodeStateful.this.source);
            if (NodeStateful.this.rounder != null) {
                NodeStateful.this.last.set(this.storedLast);
                NodeStateful.this.variable.set(this.storedVar);
                NodeStateful.this.rounderValue.set(NodeStateful.this.last);
                this.storedLast.set(NodeStateful.this.rounder);
                NodeStateful.this.rounderValue.set(NodeStateful.this.variable);
                this.storedVar.set(NodeStateful.this.rounder);
            }
        }
    }

    public static interface IGetterFunc {
        public IExpressionNode createGetter(IVariableNode var1, IVariableNode var2) throws InvalidExpressionException;
    }
}

