/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.unary;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.unary.IUnaryNodeType;
import buildcraft.lib.expression.node.unary.NodeBooleanInvert;
import buildcraft.lib.expression.node.unary.NodeUnaryDouble;
import buildcraft.lib.expression.node.unary.NodeUnaryLong;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongUnaryOperator;

public enum UnaryNodeType implements IUnaryNodeType
{
    NEGATE("-", n -> -n, n -> -n),
    BITWISE_INVERT("~", n -> n ^ 0xFFFFFFFFFFFFFFFFL, null);

    public final String op;
    public final LongUnaryOperator longFunc;
    public final DoubleUnaryOperator doubleFunc;

    private UnaryNodeType(String op, LongUnaryOperator longFunc, DoubleUnaryOperator doubleFunc) {
        this.op = op;
        this.longFunc = longFunc;
        this.doubleFunc = doubleFunc;
    }

    @Override
    public IExpressionNode.INodeLong createLongNode(IExpressionNode.INodeLong n) throws InvalidExpressionException {
        if (this.longFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on long nodes!");
        }
        return new NodeUnaryLong(n, this.longFunc, this.op);
    }

    @Override
    public IExpressionNode.INodeDouble createDoubleNode(IExpressionNode.INodeDouble n) throws InvalidExpressionException {
        if (this.doubleFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on double nodes!");
        }
        return new NodeUnaryDouble(n, this.doubleFunc, this.op);
    }

    @Override
    public IExpressionNode.INodeBoolean createBooleanNode(IExpressionNode.INodeBoolean n) throws InvalidExpressionException {
        if (this != NEGATE) {
            throw new InvalidExpressionException("Cannot perform " + this + " on boolean nodes!");
        }
        return new NodeBooleanInvert(n);
    }

    @Override
    public IExpressionNode.INodeString createStringNode(IExpressionNode.INodeString n) throws InvalidExpressionException {
        throw new InvalidExpressionException("Cannot perform " + this + " on string nodes!");
    }
}

