/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncStringToLong
implements INodeFunc.INodeFuncLong {
    public final IFuncStringToLong function;
    private final StringFunctionBi stringFunction;

    public NodeFuncStringToLong(IFuncStringToLong function) {
        this.function = function;
        this.stringFunction = null;
    }

    public NodeFuncStringToLong(IFuncStringToLong function, String fnString) {
        this(function, (String a) -> "[" + a + "] " + fnString);
    }

    public NodeFuncStringToLong(IFuncStringToLong function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction == null ? "[string -> long] {" + this.function.toString() + "}" : this.stringFunction.apply("{0}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        return new Func(stack.popString(), this.function, this.stringFunction);
    }

    public static interface IFuncStringToLong {
        public long apply(String var1);
    }

    private static class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeString arg;
        private final IFuncStringToLong function;
        private final StringFunctionBi stringFunction;

        public Func(IExpressionNode.INodeString arg, IFuncStringToLong function, StringFunctionBi stringFunction) {
            this.arg = arg;
            this.function = function;
            this.stringFunction = stringFunction;
        }

        @Override
        public long evaluate() {
            return this.function.apply(this.arg.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            return NodeInliningHelper.tryInline(this, this.arg, a -> new Func((IExpressionNode.INodeString)a, this.function, this.stringFunction), a -> new NodeConstantLong(this.function.apply(a.evaluate())));
        }

        public String toString() {
            return this.stringFunction == null ? "[" + this.arg + " -> long] {" + this.function.toString() + "}" : this.stringFunction.apply(this.arg.toString());
        }
    }
}

