/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncLongToLong
implements INodeFunc.INodeFuncLong {
    public final IFuncLongToLong function;
    private final StringFunctionBi stringFunction;

    public NodeFuncLongToLong(IFuncLongToLong function) {
        this.function = function;
        this.stringFunction = null;
    }

    public NodeFuncLongToLong(final IFuncLongToLong function, final String fnString) {
        this(new IFuncLongToLong(){

            @Override
            public long apply(long arg) {
                return function.apply(arg);
            }

            public String toString() {
                return fnString;
            }
        });
    }

    public NodeFuncLongToLong(IFuncLongToLong function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction == null ? "[long -> long] {" + this.function.toString() + "}" : this.stringFunction.apply("{0}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        return new Func(stack.popLong(), this.function, this.stringFunction);
    }

    public static interface IFuncLongToLong {
        public long apply(long var1);
    }

    private static class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeLong arg;
        private final IFuncLongToLong function;
        private final StringFunctionBi stringFunction;

        public Func(IExpressionNode.INodeLong arg, IFuncLongToLong function, StringFunctionBi stringFunction) {
            this.arg = arg;
            this.function = function;
            this.stringFunction = stringFunction;
        }

        @Override
        public long evaluate() {
            return this.function.apply(this.arg.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            return NodeInliningHelper.tryInline(this, this.arg, a -> new Func((IExpressionNode.INodeLong)a, this.function, this.stringFunction), a -> new NodeConstantLong(this.function.apply(a.evaluate())));
        }

        public String toString() {
            return this.stringFunction == null ? "[" + this.arg + " -> long] {" + this.function.toString() + "}" : this.stringFunction.apply(this.function.toString());
        }
    }
}

