/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncLongLongToLong
implements INodeFunc.INodeFuncLong {
    public final IFuncLongLongToLong function;
    private final StringFunctionTri stringFunction;

    public NodeFuncLongLongToLong(IFuncLongLongToLong function) {
        this.function = function;
        this.stringFunction = null;
    }

    public NodeFuncLongLongToLong(IFuncLongLongToLong function, String fnString) {
        this(function, (String a, String b) -> "[" + a + ", " + b + "] " + fnString);
    }

    public NodeFuncLongLongToLong(IFuncLongLongToLong function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction == null ? "[long, long -> long] {" + this.function.toString() + "}" : this.stringFunction.apply("{0}", "{1}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeLong a = stack.popLong();
        return new Func(a, b, this.function, this.stringFunction);
    }

    public static interface IFuncLongLongToLong {
        public long apply(long var1, long var3);
    }

    private static class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeLong a;
        private final IExpressionNode.INodeLong b;
        private final IFuncLongLongToLong function;
        private final StringFunctionTri stringFunction;

        public Func(IExpressionNode.INodeLong a, IExpressionNode.INodeLong b, IFuncLongLongToLong function, StringFunctionTri stringFunction) {
            this.a = a;
            this.b = b;
            this.function = function;
            this.stringFunction = stringFunction;
        }

        @Override
        public long evaluate() {
            return this.function.apply(this.a.evaluate(), this.b.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            return NodeInliningHelper.tryInline(this, this.a, this.b, (a, b) -> new Func((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b, this.function, this.stringFunction), (a, b) -> new NodeConstantLong(this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return this.stringFunction == null ? "[" + this.a + ", " + this.b + " -> long] {" + this.function.toString() + "}" : this.stringFunction.apply(this.a.toString(), this.b.toString());
        }
    }
}

