/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncDoubleToLong
implements INodeFunc.INodeFuncLong {
    public final IFuncDoubleToLong function;
    private final StringFunctionBi stringFunction;

    public NodeFuncDoubleToLong(IFuncDoubleToLong function) {
        this.function = function;
        this.stringFunction = null;
    }

    public NodeFuncDoubleToLong(IFuncDoubleToLong function, String fnString) {
        this(function, (String a) -> "[" + a + "] " + fnString);
    }

    public NodeFuncDoubleToLong(IFuncDoubleToLong function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction == null ? "[double -> long] {" + this.function.toString() + "}" : this.stringFunction.apply("{0}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        return new Func(stack.popDouble(), this.function, this.stringFunction);
    }

    public static interface IFuncDoubleToLong {
        public long apply(double var1);
    }

    private static class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeDouble arg;
        private final IFuncDoubleToLong function;
        private final StringFunctionBi stringFunction;

        public Func(IExpressionNode.INodeDouble arg, IFuncDoubleToLong function, StringFunctionBi stringFunction) {
            this.arg = arg;
            this.function = function;
            this.stringFunction = stringFunction;
        }

        @Override
        public long evaluate() {
            return this.function.apply(this.arg.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            return NodeInliningHelper.tryInline(this, this.arg, a -> new Func((IExpressionNode.INodeDouble)a, this.function, this.stringFunction), a -> new NodeConstantLong(this.function.apply(a.evaluate())));
        }

        public String toString() {
            return this.stringFunction == null ? "[" + this.arg + " -> long] {" + this.function.toString() + "}" : this.stringFunction.apply(this.arg.toString());
        }
    }
}

