/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantDouble;

public class NodeFuncDoubleToDouble
implements INodeFunc.INodeFuncDouble {
    public final IFuncDoubleToDouble function;
    private final StringFunctionBi stringFunction;

    public NodeFuncDoubleToDouble(IFuncDoubleToDouble function) {
        this.function = function;
        this.stringFunction = null;
    }

    public NodeFuncDoubleToDouble(final IFuncDoubleToDouble function, final String fnString) {
        this(new IFuncDoubleToDouble(){

            @Override
            public double apply(double arg) {
                return function.apply(arg);
            }

            public String toString() {
                return fnString;
            }
        });
    }

    public NodeFuncDoubleToDouble(IFuncDoubleToDouble function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction == null ? "[double -> double] {" + this.function.toString() + "}" : this.stringFunction.apply("{0}");
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        return new Func(stack.popDouble(), this.function, this.stringFunction);
    }

    public static interface IFuncDoubleToDouble {
        public double apply(double var1);
    }

    private static class Func
    implements IExpressionNode.INodeDouble {
        private final IExpressionNode.INodeDouble arg;
        private final IFuncDoubleToDouble function;
        private final StringFunctionBi stringFunction;

        public Func(IExpressionNode.INodeDouble arg, IFuncDoubleToDouble function, StringFunctionBi stringFunction) {
            this.arg = arg;
            this.function = function;
            this.stringFunction = stringFunction;
        }

        @Override
        public double evaluate() {
            return this.function.apply(this.arg.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            return NodeInliningHelper.tryInline(this, this.arg, a -> new Func((IExpressionNode.INodeDouble)a, this.function, this.stringFunction), a -> new NodeConstantDouble(this.function.apply(a.evaluate())));
        }

        public String toString() {
            return this.stringFunction == null ? "[" + this.arg + " -> double] {" + this.function.toString() + "}" : this.stringFunction.apply(this.arg.toString());
        }
    }
}

