/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantDouble;

public class NodeFuncDoubleDoubleToDouble
implements INodeFunc.INodeFuncDouble {
    public final IFuncDoubleDoubleToDouble function;
    private final StringFunctionTri stringFunction;

    public NodeFuncDoubleDoubleToDouble(IFuncDoubleDoubleToDouble function) {
        this.function = function;
        this.stringFunction = null;
    }

    public NodeFuncDoubleDoubleToDouble(IFuncDoubleDoubleToDouble function, String fnString) {
        this(function, (String a, String b) -> "[" + a + ", " + b + "] " + fnString);
    }

    public NodeFuncDoubleDoubleToDouble(IFuncDoubleDoubleToDouble function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction == null ? "[double, double -> double] {" + this.function.toString() + "}" : this.stringFunction.apply("{0}", "{1}");
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble b = stack.popDouble();
        IExpressionNode.INodeDouble a = stack.popDouble();
        return new Func(a, b, this.function, this.stringFunction);
    }

    public static interface IFuncDoubleDoubleToDouble {
        public double apply(double var1, double var3);
    }

    private static class Func
    implements IExpressionNode.INodeDouble {
        private final IExpressionNode.INodeDouble a;
        private final IExpressionNode.INodeDouble b;
        private final IFuncDoubleDoubleToDouble function;
        private final StringFunctionTri stringFunction;

        public Func(IExpressionNode.INodeDouble a, IExpressionNode.INodeDouble b, IFuncDoubleDoubleToDouble function, StringFunctionTri stringFunction) {
            this.a = a;
            this.b = b;
            this.function = function;
            this.stringFunction = stringFunction;
        }

        @Override
        public double evaluate() {
            return this.function.apply(this.a.evaluate(), this.b.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            return NodeInliningHelper.tryInline(this, this.a, this.b, (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b, this.function, this.stringFunction), (a, b) -> new NodeConstantDouble(this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return this.stringFunction == null ? "[" + this.a + ", " + this.b + " -> long] {" + this.function.toString() + "}" : this.stringFunction.apply(this.a.toString(), this.b.toString());
        }
    }
}

