/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.condition;

import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantString;

public class NodeConditionalString
implements IExpressionNode.INodeString {
    private final IExpressionNode.INodeBoolean condition;
    private final IExpressionNode.INodeString ifTrue;
    private final IExpressionNode.INodeString ifFalse;

    public NodeConditionalString(IExpressionNode.INodeBoolean condition, IExpressionNode.INodeString ifTrue, IExpressionNode.INodeString ifFalse) {
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public String evaluate() {
        return this.condition.evaluate() ? this.ifTrue.evaluate() : this.ifFalse.evaluate();
    }

    @Override
    public IExpressionNode.INodeString inline() {
        ExpressionDebugManager.debugStart("Inlining " + this);
        IExpressionNode.INodeBoolean c = this.condition.inline();
        IExpressionNode.INodeString t = this.ifTrue.inline();
        IExpressionNode.INodeString f = this.ifFalse.inline();
        if (c instanceof NodeConstantBoolean && t instanceof NodeConstantString && f instanceof NodeConstantString) {
            NodeConstantString val = new NodeConstantString(((NodeConstantBoolean)c).value ? ((NodeConstantString)t).value : ((NodeConstantString)f).value);
            ExpressionDebugManager.debugEnd("Fully inlined to " + val);
            return val;
        }
        if (c != this.condition || t != this.ifTrue || f != this.ifFalse) {
            NodeConditionalString val = new NodeConditionalString(c, t, f);
            ExpressionDebugManager.debugEnd("Partially inlined to " + val);
            return val;
        }
        ExpressionDebugManager.debugEnd("Unable to inline at all!");
        return this;
    }

    public String toString() {
        return "(" + this.condition + ") ? (" + this.ifTrue + ") : (" + this.ifFalse + ")";
    }
}

