/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.cast;

import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.cast.NodeCastBooleanToString;
import buildcraft.lib.expression.node.cast.NodeCastDoubleToString;
import buildcraft.lib.expression.node.cast.NodeCastLongToDouble;
import buildcraft.lib.expression.node.cast.NodeCastLongToString;

public class NodeCasting {
    public static IExpressionNode.INodeString castToString(IExpressionNode node) {
        if (node instanceof IExpressionNode.INodeString) {
            return (IExpressionNode.INodeString)node;
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return new NodeCastBooleanToString((IExpressionNode.INodeBoolean)node);
        }
        if (node instanceof IExpressionNode.INodeLong) {
            return new NodeCastLongToString((IExpressionNode.INodeLong)node);
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return new NodeCastDoubleToString((IExpressionNode.INodeDouble)node);
        }
        ExpressionDebugManager.debugNodeClass(node.getClass());
        throw new IllegalStateException("Unknown node type " + node.getClass());
    }

    public static IExpressionNode.INodeDouble castToDouble(IExpressionNode node) throws InvalidExpressionException {
        if (node instanceof IExpressionNode.INodeDouble) {
            return (IExpressionNode.INodeDouble)node;
        }
        if (node instanceof IExpressionNode.INodeLong) {
            return new NodeCastLongToDouble((IExpressionNode.INodeLong)node);
        }
        throw new InvalidExpressionException("Cannot cast " + node + " to a double!");
    }

    public static INodeFunc.INodeFuncString castToString(INodeFunc func) {
        if (func instanceof INodeFunc.INodeFuncString) {
            return (INodeFunc.INodeFuncString)func;
        }
        if (func instanceof INodeFunc.INodeFuncBoolean) {
            INodeFunc.INodeFuncBoolean funcBool = (INodeFunc.INodeFuncBoolean)func;
            return stack -> new NodeCastBooleanToString(funcBool.getNode(stack));
        }
        if (func instanceof INodeFunc.INodeFuncLong) {
            INodeFunc.INodeFuncLong funcLong = (INodeFunc.INodeFuncLong)func;
            return stack -> new NodeCastLongToString(funcLong.getNode(stack));
        }
        if (func instanceof INodeFunc.INodeFuncDouble) {
            INodeFunc.INodeFuncDouble funcDouble = (INodeFunc.INodeFuncDouble)func;
            return stack -> new NodeCastDoubleToString(funcDouble.getNode(stack));
        }
        ExpressionDebugManager.debugNodeClass(func.getClass());
        throw new IllegalStateException("Unknown node type " + func.getClass());
    }

    public static INodeFunc.INodeFuncDouble castToDouble(INodeFunc func) throws InvalidExpressionException {
        if (func instanceof INodeFunc.INodeFuncDouble) {
            return (INodeFunc.INodeFuncDouble)func;
        }
        if (func instanceof INodeFunc.INodeFuncLong) {
            INodeFunc.INodeFuncLong funcLong = (INodeFunc.INodeFuncLong)func;
            return stack -> new NodeCastLongToDouble(funcLong.getNode(stack));
        }
        throw new InvalidExpressionException("Cannot cast " + func + " to a double!");
    }
}

