/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeBinaryStringToBoolean
implements IExpressionNode.INodeBoolean {
    private final IExpressionNode.INodeString left;
    private final IExpressionNode.INodeString right;
    private final BiStringToBooleanFunction func;
    private final String op;

    public NodeBinaryStringToBoolean(IExpressionNode.INodeString left, IExpressionNode.INodeString right, BiStringToBooleanFunction func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public boolean evaluate() {
        return this.func.apply(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeBoolean inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryStringToBoolean((IExpressionNode.INodeString)l, (IExpressionNode.INodeString)r, this.func, this.op), (l, r) -> NodeConstantBoolean.get(this.func.apply(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }

    @FunctionalInterface
    public static interface BiStringToBooleanFunction {
        public boolean apply(String var1, String var2);
    }
}

