/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantString;

public class NodeBinaryString
implements IExpressionNode.INodeString {
    private final IExpressionNode.INodeString left;
    private final IExpressionNode.INodeString right;
    private final BiStringFunction func;
    private final String op;

    public NodeBinaryString(IExpressionNode.INodeString left, IExpressionNode.INodeString right, BiStringFunction func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public String evaluate() {
        return this.func.apply(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeString inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryString((IExpressionNode.INodeString)l, (IExpressionNode.INodeString)r, this.func, this.op), (l, r) -> new NodeConstantString(this.func.apply(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }

    @FunctionalInterface
    public static interface BiStringFunction {
        public String apply(String var1, String var2);
    }
}

