/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeBinaryLongToBoolean
implements IExpressionNode.INodeBoolean {
    private final IExpressionNode.INodeLong left;
    private final IExpressionNode.INodeLong right;
    private final BiLongToBooleanFunction func;
    private final String op;

    public NodeBinaryLongToBoolean(IExpressionNode.INodeLong left, IExpressionNode.INodeLong right, BiLongToBooleanFunction func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public boolean evaluate() {
        return this.func.apply(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeBoolean inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryLongToBoolean((IExpressionNode.INodeLong)l, (IExpressionNode.INodeLong)r, this.func, this.op), (l, r) -> NodeConstantBoolean.get(this.func.apply(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }

    @FunctionalInterface
    public static interface BiLongToBooleanFunction {
        public boolean apply(long var1, long var3);
    }
}

