/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import java.util.function.LongBinaryOperator;

public class NodeBinaryLong
implements IExpressionNode.INodeLong {
    private final IExpressionNode.INodeLong left;
    private final IExpressionNode.INodeLong right;
    private final LongBinaryOperator func;
    private final String op;

    public NodeBinaryLong(IExpressionNode.INodeLong left, IExpressionNode.INodeLong right, LongBinaryOperator func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public long evaluate() {
        return this.func.applyAsLong(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeLong inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryLong((IExpressionNode.INodeLong)l, (IExpressionNode.INodeLong)r, this.func, this.op), (l, r) -> new NodeConstantLong(this.func.applyAsLong(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }
}

