/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeBinaryDoubleToBoolean
implements IExpressionNode.INodeBoolean {
    private final IExpressionNode.INodeDouble left;
    private final IExpressionNode.INodeDouble right;
    private final BiDoubleToBooleanFunction func;
    private final String op;

    public NodeBinaryDoubleToBoolean(IExpressionNode.INodeDouble left, IExpressionNode.INodeDouble right, BiDoubleToBooleanFunction func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public boolean evaluate() {
        return this.func.apply(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeBoolean inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryDoubleToBoolean((IExpressionNode.INodeDouble)l, (IExpressionNode.INodeDouble)r, this.func, this.op), (l, r) -> NodeConstantBoolean.get(this.func.apply(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }

    @FunctionalInterface
    public static interface BiDoubleToBooleanFunction {
        public boolean apply(double var1, double var3);
    }
}

