/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.function.DoubleBinaryOperator;

public class NodeBinaryDouble
implements IExpressionNode.INodeDouble {
    private final IExpressionNode.INodeDouble left;
    private final IExpressionNode.INodeDouble right;
    private final DoubleBinaryOperator func;
    private final String op;

    public NodeBinaryDouble(IExpressionNode.INodeDouble left, IExpressionNode.INodeDouble right, DoubleBinaryOperator func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public double evaluate() {
        return this.func.applyAsDouble(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeDouble inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryDouble((IExpressionNode.INodeDouble)l, (IExpressionNode.INodeDouble)r, this.func, this.op), (l, r) -> new NodeConstantDouble(this.func.applyAsDouble(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }
}

