/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeBinaryBoolean
implements IExpressionNode.INodeBoolean {
    private final IExpressionNode.INodeBoolean left;
    private final IExpressionNode.INodeBoolean right;
    private final BiBooleanPredicate func;
    private final String op;

    public NodeBinaryBoolean(IExpressionNode.INodeBoolean left, IExpressionNode.INodeBoolean right, BiBooleanPredicate func, String op) {
        this.left = left;
        this.right = right;
        this.func = func;
        this.op = op;
    }

    @Override
    public boolean evaluate() {
        return this.func.apply(this.left.evaluate(), this.right.evaluate());
    }

    @Override
    public IExpressionNode.INodeBoolean inline() {
        return NodeInliningHelper.tryInline(this, this.left, this.right, (l, r) -> new NodeBinaryBoolean((IExpressionNode.INodeBoolean)l, (IExpressionNode.INodeBoolean)r, this.func, this.op), (l, r) -> NodeConstantBoolean.get(this.func.apply(l.evaluate(), r.evaluate())));
    }

    public String toString() {
        return "(" + this.left + ") " + this.op + " (" + this.right + ")";
    }

    @FunctionalInterface
    public static interface BiBooleanPredicate {
        public boolean apply(boolean var1, boolean var2);
    }
}

