/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.InternalCompiler;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;

public interface IBinaryNodeType {
    public IExpressionNode createLongNode(IExpressionNode.INodeLong var1, IExpressionNode.INodeLong var2) throws InvalidExpressionException;

    public IExpressionNode createDoubleNode(IExpressionNode.INodeDouble var1, IExpressionNode.INodeDouble var2) throws InvalidExpressionException;

    public IExpressionNode createBooleanNode(IExpressionNode.INodeBoolean var1, IExpressionNode.INodeBoolean var2) throws InvalidExpressionException;

    public IExpressionNode createStringNode(IExpressionNode.INodeString var1, IExpressionNode.INodeString var2) throws InvalidExpressionException;

    default public IExpressionNode createNode(IExpressionNode left, IExpressionNode right) throws InvalidExpressionException {
        left = InternalCompiler.convertBinary(left, right);
        right = InternalCompiler.convertBinary(right, left);
        if (left instanceof IExpressionNode.INodeLong) {
            return this.createLongNode((IExpressionNode.INodeLong)left, (IExpressionNode.INodeLong)right);
        }
        if (left instanceof IExpressionNode.INodeDouble) {
            return this.createDoubleNode((IExpressionNode.INodeDouble)left, (IExpressionNode.INodeDouble)right);
        }
        if (left instanceof IExpressionNode.INodeBoolean) {
            return this.createBooleanNode((IExpressionNode.INodeBoolean)left, (IExpressionNode.INodeBoolean)right);
        }
        if (left instanceof IExpressionNode.INodeString) {
            return this.createStringNode((IExpressionNode.INodeString)left, (IExpressionNode.INodeString)right);
        }
        throw new InvalidExpressionException("Unknown node " + left + ", " + right);
    }
}

