/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.binary.IBinaryNodeType;
import buildcraft.lib.expression.node.binary.NodeBinaryBoolean;
import buildcraft.lib.expression.node.binary.NodeBinaryDouble;
import buildcraft.lib.expression.node.binary.NodeBinaryLong;
import buildcraft.lib.expression.node.binary.NodeBinaryString;
import java.util.function.DoubleBinaryOperator;
import java.util.function.LongBinaryOperator;

public enum BiNodeType implements IBinaryNodeType
{
    AND("&", (l, r) -> l & r, null, (l, r) -> l & r, (l, r) -> l + r),
    OR("|", (l, r) -> l | r, null, (l, r) -> l | r, null),
    XOR("^", (l, r) -> l ^ r, null, (l, r) -> l ^ r, null),
    ADD("+", (l, r) -> l + r, (l, r) -> l + r, null, (l, r) -> l + r),
    SUB("-", (l, r) -> l - r, (l, r) -> l - r, null, null),
    MUL("*", (l, r) -> l * r, (l, r) -> l * r, null, null),
    DIV("/", (l, r) -> l / r, (l, r) -> l / r, null, null),
    MOD("%", (l, r) -> l % r, (l, r) -> l % r, null, null),
    SHIFT_RIGHT("<<", (l, r) -> l << (int)r, null, null, null),
    SHIFT_LEFT(">>", (l, r) -> l >> (int)r, null, null, null);

    public final String op;
    public final LongBinaryOperator longFunc;
    public final DoubleBinaryOperator doubleFunc;
    public final NodeBinaryBoolean.BiBooleanPredicate booleanFunction;
    public final NodeBinaryString.BiStringFunction stringFunc;

    private BiNodeType(String op, LongBinaryOperator longFunc, DoubleBinaryOperator doubleFunc, NodeBinaryBoolean.BiBooleanPredicate booleanFunction, NodeBinaryString.BiStringFunction stringFunc) {
        this.op = op;
        this.longFunc = longFunc;
        this.doubleFunc = doubleFunc;
        this.booleanFunction = booleanFunction;
        this.stringFunc = stringFunc;
    }

    @Override
    public IExpressionNode.INodeLong createLongNode(IExpressionNode.INodeLong l, IExpressionNode.INodeLong r) throws InvalidExpressionException {
        if (this.longFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on long nodes!");
        }
        return new NodeBinaryLong(l, r, this.longFunc, this.op);
    }

    @Override
    public IExpressionNode.INodeDouble createDoubleNode(IExpressionNode.INodeDouble l, IExpressionNode.INodeDouble r) throws InvalidExpressionException {
        if (this.doubleFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on double nodes!");
        }
        return new NodeBinaryDouble(l, r, this.doubleFunc, this.op);
    }

    @Override
    public IExpressionNode.INodeBoolean createBooleanNode(IExpressionNode.INodeBoolean l, IExpressionNode.INodeBoolean r) throws InvalidExpressionException {
        if (this.booleanFunction == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on boolean nodes!");
        }
        return new NodeBinaryBoolean(l, r, this.booleanFunction, this.op);
    }

    @Override
    public IExpressionNode.INodeString createStringNode(IExpressionNode.INodeString l, IExpressionNode.INodeString r) throws InvalidExpressionException {
        if (this.stringFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on string nodes!");
        }
        return new NodeBinaryString(l, r, this.stringFunc, this.op);
    }
}

