/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.binary;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.binary.IBinaryNodeType;
import buildcraft.lib.expression.node.binary.NodeBinaryBoolean;
import buildcraft.lib.expression.node.binary.NodeBinaryDoubleToBoolean;
import buildcraft.lib.expression.node.binary.NodeBinaryLongToBoolean;
import buildcraft.lib.expression.node.binary.NodeBinaryStringToBoolean;
import com.google.common.base.Objects;

public enum BiNodeToBooleanType implements IBinaryNodeType
{
    EQUAL("==", (l, r) -> l == r, (l, r) -> l == r, (l, r) -> l == r, Objects::equal),
    NOT_EQUAL("!=", (l, r) -> l != r, (l, r) -> l != r, (l, r) -> l != r, (l, r) -> !Objects.equal((Object)l, (Object)r)),
    LESS_THAN("<", (l, r) -> l < r, (l, r) -> l < r, null, (l, r) -> l.compareTo(r) < 0),
    GREATER_THAN(">", (l, r) -> l > r, (l, r) -> l > r, null, (l, r) -> l.compareTo(r) > 0),
    LESS_THAN_OR_EQUAL("<=", (l, r) -> l <= r, (l, r) -> l <= r, null, (l, r) -> l.compareTo(r) <= 0),
    GREATER_THAN_OR_EQUAL(">=", (l, r) -> l >= r, (l, r) -> l >= r, null, (l, r) -> l.compareTo(r) >= 0);

    public final String op;
    public final NodeBinaryLongToBoolean.BiLongToBooleanFunction longFunc;
    public final NodeBinaryDoubleToBoolean.BiDoubleToBooleanFunction doubleFunc;
    public final NodeBinaryBoolean.BiBooleanPredicate booleanFunction;
    public final NodeBinaryStringToBoolean.BiStringToBooleanFunction stringFunc;

    private BiNodeToBooleanType(String op, NodeBinaryLongToBoolean.BiLongToBooleanFunction longFunc, NodeBinaryDoubleToBoolean.BiDoubleToBooleanFunction doubleFunc, NodeBinaryBoolean.BiBooleanPredicate booleanFunction, NodeBinaryStringToBoolean.BiStringToBooleanFunction stringFunc) {
        this.op = op;
        this.longFunc = longFunc;
        this.doubleFunc = doubleFunc;
        this.booleanFunction = booleanFunction;
        this.stringFunc = stringFunc;
    }

    @Override
    public IExpressionNode.INodeBoolean createLongNode(IExpressionNode.INodeLong l, IExpressionNode.INodeLong r) throws InvalidExpressionException {
        if (this.longFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on long nodes!");
        }
        return new NodeBinaryLongToBoolean(l, r, this.longFunc, this.op);
    }

    @Override
    public IExpressionNode.INodeBoolean createDoubleNode(IExpressionNode.INodeDouble l, IExpressionNode.INodeDouble r) throws InvalidExpressionException {
        if (this.doubleFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on double nodes!");
        }
        return new NodeBinaryDoubleToBoolean(l, r, this.doubleFunc, this.op);
    }

    @Override
    public IExpressionNode.INodeBoolean createBooleanNode(IExpressionNode.INodeBoolean l, IExpressionNode.INodeBoolean r) throws InvalidExpressionException {
        if (this.booleanFunction == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on boolean nodes!");
        }
        return new NodeBinaryBoolean(l, r, this.booleanFunction, this.op);
    }

    @Override
    public IExpressionNode.INodeBoolean createStringNode(IExpressionNode.INodeString l, IExpressionNode.INodeString r) throws InvalidExpressionException {
        if (this.stringFunc == null) {
            throw new InvalidExpressionException("Cannot perform " + this + " on string nodes!");
        }
        return new NodeBinaryStringToBoolean(l, r, this.stringFunc, this.op);
    }
}

