/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.api;

import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.cast.NodeCasting;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.expression.node.value.NodeConstantString;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableLong;
import buildcraft.lib.expression.node.value.NodeVariableString;

public enum NodeType {
    LONG,
    DOUBLE,
    BOOLEAN,
    STRING;


    public static NodeType parseType(String type) throws InvalidExpressionException {
        for (NodeType n : NodeType.values()) {
            if (!n.name().equalsIgnoreCase(type)) continue;
            return n;
        }
        throw new InvalidExpressionException("Unknown type " + type + ", must be one of ['long', 'double', 'boolean', 'string'], without the quotes.");
    }

    public static NodeType getType(IExpressionNode node) {
        if (node instanceof IExpressionNode.INodeLong) {
            return LONG;
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return DOUBLE;
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return BOOLEAN;
        }
        if (node instanceof IExpressionNode.INodeString) {
            return STRING;
        }
        throw new IllegalArgumentException("Illegal node " + node.getClass());
    }

    public IVariableNode makeVariableNode(String name) {
        switch (this) {
            case BOOLEAN: {
                return new NodeVariableBoolean(name);
            }
            case DOUBLE: {
                return new NodeVariableDouble(name);
            }
            case LONG: {
                return new NodeVariableLong(name);
            }
            case STRING: {
                return new NodeVariableString(name);
            }
        }
        throw new IllegalStateException("Unknown node type '" + (Object)((Object)this) + "'");
    }

    public static IConstantNode createConstantNode(IExpressionNode node) {
        if (node instanceof IExpressionNode.INodeLong) {
            return new NodeConstantLong(((IExpressionNode.INodeLong)node).evaluate());
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return new NodeConstantDouble(((IExpressionNode.INodeDouble)node).evaluate());
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return NodeConstantBoolean.get(((IExpressionNode.INodeBoolean)node).evaluate());
        }
        if (node instanceof IExpressionNode.INodeString) {
            return new NodeConstantString(((IExpressionNode.INodeString)node).evaluate());
        }
        throw new IllegalArgumentException("Illegal node " + node.getClass());
    }

    public IExpressionNode cast(IExpressionNode node) throws InvalidExpressionException {
        switch (this) {
            case DOUBLE: {
                return NodeCasting.castToDouble(node);
            }
            case STRING: {
                return NodeCasting.castToString(node);
            }
            case LONG: {
                if (node instanceof IExpressionNode.INodeLong) {
                    return node;
                }
                throw new InvalidExpressionException("Cannot cast " + (Object)((Object)NodeType.getType(node)) + " to a long");
            }
            case BOOLEAN: {
                if (node instanceof IExpressionNode.INodeBoolean) {
                    return node;
                }
                throw new InvalidExpressionException("Cannot cast " + (Object)((Object)NodeType.getType(node)) + " to a boolean");
            }
        }
        throw new IllegalStateException("Unknown node type '" + (Object)((Object)this) + "'");
    }
}

