/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.api;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;

public interface INodeStack {
    public IExpressionNode.INodeLong popLong() throws InvalidExpressionException;

    public IExpressionNode.INodeDouble popDouble() throws InvalidExpressionException;

    public IExpressionNode.INodeBoolean popBoolean() throws InvalidExpressionException;

    public IExpressionNode.INodeString popString() throws InvalidExpressionException;

    default public IExpressionNode pop(NodeType type) throws InvalidExpressionException {
        if (type == NodeType.LONG) {
            return this.popLong();
        }
        if (type == NodeType.DOUBLE) {
            return this.popDouble();
        }
        if (type == NodeType.BOOLEAN) {
            return this.popBoolean();
        }
        if (type == NodeType.STRING) {
            return this.popString();
        }
        throw new IllegalArgumentException("Unknown node type " + (Object)((Object)type));
    }
}

