/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Tokenizer {
    public static final char END_OF_LINE = '\n';
    private final List<ITokenizerGobbler> tokenizers;

    public Tokenizer(List<ITokenizerGobbler> tokenizers) {
        this.tokenizers = ImmutableList.copyOf(tokenizers);
    }

    public Tokenizer(ITokenizerGobbler ... tokenizers) {
        this(Arrays.asList(tokenizers));
    }

    public String[] tokenize(String src) throws InvalidExpressionException {
        ArrayList<String> tokens = new ArrayList<String>();
        int index = 0;
        while (index < src.length()) {
            int contextStart = index;
            ITokenizingContext ctx = ITokenizingContext.createFromString(contextStart, src);
            boolean consumed = false;
            for (ITokenizerGobbler token : this.tokenizers) {
                TokenResult res = token.tokenizePart(ctx);
                if (res == ResultSpecific.IGNORE) continue;
                if (res == ResultSpecific.INVALID) {
                    throw new InvalidExpressionException("Invalid src \"" + ctx.get(10).replace("\n", "\\n") + "\"");
                }
                if (res instanceof ResultInvalid) {
                    throw new InvalidExpressionException("Invalid src \"" + ctx.get(((ResultInvalid)res).length).replace("\n", "\\n") + "\"");
                }
                if (res instanceof ResultDiscard) {
                    int discardLength = ((ResultDiscard)res).length;
                    index += discardLength;
                    consumed = true;
                    break;
                }
                if (!(res instanceof ResultConsume)) continue;
                int consumedLength = ((ResultConsume)res).length;
                String at = ctx.get(consumedLength);
                tokens.add(at);
                index += consumedLength;
                consumed = true;
                break;
            }
            if (consumed) continue;
            throw new InvalidExpressionException("Did not consume:" + ctx.get(50));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static class ResultDiscard
    implements TokenResult {
        public static final ResultDiscard SINGLE = new ResultDiscard(1);
        public final int length;

        public ResultDiscard(int length) {
            this.length = length;
        }
    }

    public static class ResultConsume
    implements TokenResult {
        public static final ResultConsume ONE = new ResultConsume(1);
        public static final ResultConsume TWO = new ResultConsume(2);
        public final int length;

        public ResultConsume(int length) {
            this.length = length;
        }
    }

    public static class ResultInvalid
    implements TokenResult {
        public final int length;

        public ResultInvalid(int length) {
            this.length = length;
        }
    }

    public static enum ResultSpecific implements TokenResult
    {
        IGNORE,
        INVALID;

    }

    public static interface TokenResult {
    }

    @FunctionalInterface
    public static interface ITokenizerGobbler {
        public TokenResult tokenizePart(ITokenizingContext var1);
    }

    @FunctionalInterface
    public static interface ITokenizingContext {
        public String get(int var1, int var2);

        default public String get(int length) {
            return this.get(0, length);
        }

        default public char getCharAt(int rel) {
            return this.get(rel, rel + 1).charAt(0);
        }

        public static ITokenizingContext createFromString(String src) {
            return ITokenizingContext.createFromString(0, src);
        }

        public static ITokenizingContext createFromString(int contextStart, String src) {
            return (relStart, relEnd) -> {
                int start = contextStart + relStart;
                int end = contextStart + relEnd;
                int stringEnd = src.length();
                StringBuilder gotten = new StringBuilder(src.substring(start, Math.min(end, stringEnd)));
                while (gotten.length() < end - start) {
                    gotten.append('\n');
                }
                return gotten.toString();
            };
        }
    }
}

