/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.node.cast.NodeCasting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class NodeStack
implements INodeStack {
    private final Deque<IExpressionNode> stack = new ArrayDeque<IExpressionNode>();
    private INodeFunc currentlyPopping;
    private List<NodeType> recordingTypes;
    private int index = 0;

    public NodeStack() {
    }

    public NodeStack(IExpressionNode ... nodes) {
        for (IExpressionNode node : nodes) {
            this.push(node);
        }
    }

    public <T extends IExpressionNode> T push(T node) {
        this.stack.push(node);
        ExpressionDebugManager.debugPrintln("Pushed " + node);
        return node;
    }

    public IExpressionNode pop() throws InvalidExpressionException {
        if (this.stack.isEmpty()) {
            throw new InvalidExpressionException("No more nodes to pop!");
        }
        ExpressionDebugManager.debugPrintln("Popped " + this.stack.peek());
        return this.stack.pop();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void setRecorder(List<NodeType> expected, INodeFunc toTest) throws InvalidExpressionException {
        this.checkAndRemoveRecorder();
        ExpressionDebugManager.debugStart("Recording " + toTest + ", expecting " + expected);
        this.recordingTypes = new ArrayList<NodeType>(expected);
        this.currentlyPopping = toTest;
        this.index = 0;
    }

    public void checkAndRemoveRecorder() throws InvalidExpressionException {
        if (this.recordingTypes == null) {
            return;
        }
        if (this.index != this.recordingTypes.size()) {
            throw new InvalidExpressionException("Only removed " + this.recordingTypes.subList(0, this.index) + ", expected to remove " + this.recordingTypes + " for " + this.currentlyPopping);
        }
        ExpressionDebugManager.debugEnd("Record was correct");
        this.recordingTypes = null;
        this.currentlyPopping = null;
        this.index = 0;
    }

    private void checkTypeMatch(NodeType type) throws InvalidExpressionException {
        if (this.recordingTypes == null) {
            return;
        }
        if (this.index >= this.recordingTypes.size()) {
            throw new InvalidExpressionException("Attempted to pop off " + (Object)((Object)type) + ", but the function was not allowed to!");
        }
        NodeType said = this.recordingTypes.get(this.index);
        if (said != type) {
            throw new InvalidExpressionException("Attempted to pop off " + (Object)((Object)type) + ", but the function previously popped off !");
        }
        ++this.index;
    }

    public String toString() {
        return this.stack.toString();
    }

    @Override
    public IExpressionNode.INodeLong popLong() throws InvalidExpressionException {
        this.checkTypeMatch(NodeType.LONG);
        IExpressionNode node = this.pop();
        if (node instanceof IExpressionNode.INodeLong) {
            return (IExpressionNode.INodeLong)node;
        }
        throw new InvalidExpressionException("Cannot cast " + node + " to a long!");
    }

    @Override
    public IExpressionNode.INodeDouble popDouble() throws InvalidExpressionException {
        this.checkTypeMatch(NodeType.DOUBLE);
        return NodeCasting.castToDouble(this.pop());
    }

    @Override
    public IExpressionNode.INodeBoolean popBoolean() throws InvalidExpressionException {
        this.checkTypeMatch(NodeType.BOOLEAN);
        IExpressionNode node = this.pop();
        if (node instanceof IExpressionNode.INodeBoolean) {
            return (IExpressionNode.INodeBoolean)node;
        }
        throw new InvalidExpressionException("Cannot cast " + node + " to a boolean!");
    }

    @Override
    public IExpressionNode.INodeString popString() throws InvalidExpressionException {
        this.checkTypeMatch(NodeType.STRING);
        return NodeCasting.castToString(this.pop());
    }
}

