/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import java.util.function.BiFunction;
import java.util.function.Function;

public class NodeInliningHelper {
    public static <F extends IExpressionNode, T extends IExpressionNode> T tryInline(T node, F subNode, Function<F, T> changer, Function<F, T> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode subInlined = subNode.inline();
        if (subInlined instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(subInlined);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (T)to;
        }
        if (subInlined == subNode) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(subInlined);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (T)to;
    }

    public static <F extends IExpressionNode, T extends IExpressionNode> T tryInline(T node, F subNodeLeft, F subNodeRight, BiFunction<F, F, T> changer, BiFunction<F, F, T> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode leftInlined = subNodeLeft.inline();
        IExpressionNode rightInlined = subNodeRight.inline();
        if (leftInlined instanceof IConstantNode && rightInlined instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(leftInlined, rightInlined);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (T)to;
        }
        if (leftInlined == subNodeLeft && rightInlined == subNodeRight) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(leftInlined, rightInlined);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (T)to;
    }
}

