/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.Argument;
import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.NodeStack;
import buildcraft.lib.expression.NodeStackRecording;
import buildcraft.lib.expression.TokenizerDefaults;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.node.binary.BiNodeToBooleanType;
import buildcraft.lib.expression.node.binary.BiNodeType;
import buildcraft.lib.expression.node.binary.IBinaryNodeType;
import buildcraft.lib.expression.node.cast.NodeCastBooleanToString;
import buildcraft.lib.expression.node.cast.NodeCastDoubleToString;
import buildcraft.lib.expression.node.cast.NodeCastLongToDouble;
import buildcraft.lib.expression.node.cast.NodeCastLongToString;
import buildcraft.lib.expression.node.condition.NodeConditionalBoolean;
import buildcraft.lib.expression.node.condition.NodeConditionalDouble;
import buildcraft.lib.expression.node.condition.NodeConditionalLong;
import buildcraft.lib.expression.node.condition.NodeConditionalString;
import buildcraft.lib.expression.node.func.NodeFuncGenericToBoolean;
import buildcraft.lib.expression.node.func.NodeFuncGenericToDouble;
import buildcraft.lib.expression.node.func.NodeFuncGenericToLong;
import buildcraft.lib.expression.node.func.NodeFuncGenericToString;
import buildcraft.lib.expression.node.unary.IUnaryNodeType;
import buildcraft.lib.expression.node.unary.UnaryNodeType;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.expression.node.value.NodeConstantString;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class InternalCompiler {
    private static final String UNARY_NEGATION = "\u00ac";
    private static final String FUNCTION_START = "@";
    private static final String FUNCTION_ARGS = "#";
    private static final String OPERATORS = "+-*/^%~?:& << >> >>> == <= >= && || !=";
    private static final String leftAssociative = "+-^*/%||&&==!=<=>=<<>>?&";
    private static final String rightAssociative = "";
    private static final String[] precedence = new String[]{"(),", "?", "&& ||", "!= == <= >=", "<< >>", "+-", "%", "*/", "^", "~\u00ac"};
    private static final String LONG_REGEX = "[-+]?(0x[0-9a-fA-F_]+|[0-9]+)";
    private static final String DOUBLE_REGEX = "[-+]?[0-9]+(\\.[0-9]+)?";
    private static final String BOOLEAN_REGEX = "true|false";
    private static final String STRING_REGEX = "'.*'";
    private static final Pattern LONG_MATCHER = Pattern.compile("[-+]?(0x[0-9a-fA-F_]+|[0-9]+)");
    private static final Pattern DOUBLE_MATCHER = Pattern.compile("[-+]?[0-9]+(\\.[0-9]+)?");
    private static final Pattern BOOLEAN_MATCHER = Pattern.compile("true|false");
    private static final Pattern STRING_MATCHER = Pattern.compile("'.*'");

    public static IExpressionNode compileExpression(String expression, FunctionContext context) throws InvalidExpressionException {
        try {
            ExpressionDebugManager.debugPrintln("Compiling " + expression);
            String[] infix = InternalCompiler.tokenize(expression);
            Object[] postfix = InternalCompiler.convertToPostfix(infix);
            ExpressionDebugManager.debugPrintln(Arrays.toString(postfix));
            return InternalCompiler.makeExpression((String[])postfix, context);
        }
        catch (InvalidExpressionException iee) {
            throw new InvalidExpressionException("Failed to compile expression " + expression, iee);
        }
    }

    public static INodeFunc compileFunction(String expression, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        FunctionContext ctxReal = new FunctionContext(context);
        IVariableNode[] nodes = new IVariableNode[args.length];
        NodeType[] types = new NodeType[args.length];
        for (int i = 0; i < nodes.length; ++i) {
            types[i] = args[i].type;
            nodes[i] = ctxReal.putVariable(args[i].name, args[i].type);
        }
        IExpressionNode node = InternalCompiler.compileExpression(expression, ctxReal);
        if (node instanceof IExpressionNode.INodeLong) {
            return new NodeFuncGenericToLong((IExpressionNode.INodeLong)node, types, nodes);
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return new NodeFuncGenericToDouble((IExpressionNode.INodeDouble)node, types, nodes);
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return new NodeFuncGenericToBoolean((IExpressionNode.INodeBoolean)node, types, nodes);
        }
        if (node instanceof IExpressionNode.INodeString) {
            return new NodeFuncGenericToString((IExpressionNode.INodeString)node, types, nodes);
        }
        ExpressionDebugManager.debugNodeClass(node.getClass());
        throw new IllegalStateException("Unknown node " + node.getClass());
    }

    private static String[] tokenize(String function) throws InvalidExpressionException {
        return TokenizerDefaults.createTokenizer().tokenize(function);
    }

    private static int getPrecedence(String token) {
        int p = 0;
        if (token.startsWith(FUNCTION_START)) {
            return 0;
        }
        for (String pre : precedence) {
            if (pre.contains(token)) {
                return p;
            }
            ++p;
        }
        return p;
    }

    private static String[] convertToPostfix(String[] infix) throws InvalidExpressionException {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        ArrayList<String> postfix = new ArrayList<String>();
        int index = 0;
        ExpressionDebugManager.debugPrintln("Converting " + Arrays.toString(infix));
        ExpressionDebugManager.debugPrintln("         Stack=" + stack + ", postfix=" + postfix);
        boolean justPushedFunc = false;
        for (index = 0; index < infix.length; ++index) {
            boolean found;
            String token = infix[index];
            ExpressionDebugManager.debugPrintln("  - Token \"" + token + "\"");
            if (justPushedFunc && !")".equals(token) && stack.peek() != null && ((String)stack.peek()).startsWith(FUNCTION_START)) {
                stack.push(",");
            }
            justPushedFunc = false;
            if (",".equals(token)) {
                int commas = 1;
                found = false;
                while (!stack.isEmpty()) {
                    String fromStack = (String)stack.pop();
                    if ("(".equals(fromStack) || fromStack.startsWith(FUNCTION_START)) {
                        found = true;
                        stack.push(fromStack);
                        break;
                    }
                    if (",".equals(fromStack)) {
                        ++commas;
                        continue;
                    }
                    postfix.add(fromStack);
                }
                for (int i = 0; i < commas; ++i) {
                    stack.push(",");
                }
                if (!found) {
                    throw new InvalidExpressionException("Did not find an opening parenthesis for the comma!");
                }
            } else if ("(".equals(token)) {
                stack.push(token);
            } else if (")".equals(token)) {
                int commas = 0;
                found = false;
                while (!stack.isEmpty()) {
                    String fromStack = (String)stack.pop();
                    if ("(".equals(fromStack)) {
                        found = true;
                        break;
                    }
                    if (fromStack.startsWith(FUNCTION_START)) {
                        found = true;
                        fromStack = fromStack + FUNCTION_ARGS + commas;
                        postfix.add(fromStack);
                        break;
                    }
                    if (",".equals(fromStack)) {
                        ++commas;
                        continue;
                    }
                    postfix.add(fromStack);
                }
                if (!found) {
                    throw new InvalidExpressionException("Too many closing parenthesis!");
                }
            } else if (":".equals(token)) {
                String s;
                while ((s = (String)stack.peek()) != null && !"?".equals(s)) {
                    postfix.add((String)stack.pop());
                }
            } else if (OPERATORS.contains(token)) {
                String s;
                if ("-".equals(token) && (index == 0 || "+-*/^%~?:& << >> >>> == <= >= && || !=(,".contains(infix[index - 1]))) {
                    token = UNARY_NEGATION;
                }
                while ((s = (String)stack.peek()) != null) {
                    boolean shouldContinue;
                    boolean continueIfEqual;
                    int tokenPrec = InternalCompiler.getPrecedence(token);
                    int stackPrec = InternalCompiler.getPrecedence(s);
                    boolean bl = continueIfEqual = !"?".contains(token);
                    boolean bl2 = leftAssociative.contains(token) && (continueIfEqual ? tokenPrec <= stackPrec : tokenPrec < stackPrec) ? true : (shouldContinue = false);
                    if (!shouldContinue && rightAssociative.contains(token) && tokenPrec > stackPrec) {
                        shouldContinue = true;
                    }
                    if (!shouldContinue) break;
                    postfix.add((String)stack.pop());
                }
                stack.push(token);
            } else if (index + 1 < infix.length && "(".equals(infix[index + 1])) {
                justPushedFunc = true;
                stack.push(FUNCTION_START + token);
                ++index;
            } else {
                postfix.add(token);
            }
            ExpressionDebugManager.debugPrintln("         Stack=" + stack + ", postfix=" + postfix);
        }
        while (!stack.isEmpty()) {
            String operator = (String)stack.pop();
            ExpressionDebugManager.debugPrintln("  - Operator \"" + operator + "\"");
            if ("(".equals(operator)) {
                throw new InvalidExpressionException("Too many opening parenthesis!");
            }
            if (")".equals(operator)) {
                throw new InvalidExpressionException("Too many closing parenthesis!");
            }
            postfix.add(operator);
            ExpressionDebugManager.debugPrintln("         Stack=" + stack + ", postfix=" + postfix);
        }
        return postfix.toArray(new String[postfix.size()]);
    }

    private static IExpressionNode makeExpression(String[] postfix, FunctionContext context) throws InvalidExpressionException {
        NodeStack stack = new NodeStack();
        for (String op : postfix) {
            IExpressionNode node;
            if ("-".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.SUB);
                continue;
            }
            if ("+".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.ADD);
                continue;
            }
            if ("^".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.XOR);
                continue;
            }
            if ("&".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.AND);
                continue;
            }
            if ("|".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.OR);
                continue;
            }
            if ("&&".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.AND);
                continue;
            }
            if ("||".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.OR);
                continue;
            }
            if ("*".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.MUL);
                continue;
            }
            if ("/".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.DIV);
                continue;
            }
            if ("%".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.MOD);
                continue;
            }
            if (">>".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.SHIFT_LEFT);
                continue;
            }
            if ("<<".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeType.SHIFT_RIGHT);
                continue;
            }
            if ("~".equals(op)) {
                InternalCompiler.pushUnaryNode(stack, UnaryNodeType.BITWISE_INVERT);
                continue;
            }
            if ("==".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeToBooleanType.EQUAL);
                continue;
            }
            if ("!=".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeToBooleanType.NOT_EQUAL);
                continue;
            }
            if ("<=".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeToBooleanType.LESS_THAN_OR_EQUAL);
                continue;
            }
            if (">=".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeToBooleanType.GREATER_THAN_OR_EQUAL);
                continue;
            }
            if ("<".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeToBooleanType.LESS_THAN);
                continue;
            }
            if (">".equals(op)) {
                InternalCompiler.pushBiNode(stack, BiNodeToBooleanType.GREATER_THAN);
                continue;
            }
            if ("!".equals(op)) {
                InternalCompiler.pushUnaryNode(stack, UnaryNodeType.NEGATE);
                continue;
            }
            if (":".equals(op)) continue;
            if ("?".equals(op)) {
                InternalCompiler.pushConditional(stack);
                continue;
            }
            if (UNARY_NEGATION.equals(op)) {
                InternalCompiler.pushUnaryNode(stack, UnaryNodeType.NEGATE);
                continue;
            }
            if (InternalCompiler.isValidLong(op)) {
                long val = InternalCompiler.parseValidLong(op);
                stack.push(new NodeConstantLong(val));
                continue;
            }
            if (InternalCompiler.isValidDouble(op)) {
                stack.push(new NodeConstantDouble(Double.parseDouble(op)));
                continue;
            }
            if (BOOLEAN_MATCHER.matcher(op).matches()) {
                stack.push(NodeConstantBoolean.get(Boolean.parseBoolean(op)));
                continue;
            }
            if (STRING_MATCHER.matcher(op).matches()) {
                stack.push(new NodeConstantString(op.substring(1, op.length() - 1)));
                continue;
            }
            if (op.startsWith(FUNCTION_START)) {
                String function = op.substring(1);
                InternalCompiler.pushFunctionNode(stack, function, context);
                continue;
            }
            IExpressionNode iExpressionNode = node = context == null ? null : context.getVariable(op);
            if (node != null) {
                stack.push(node);
                continue;
            }
            throw new InvalidExpressionException("Unknown variable '" + op + "'");
        }
        IExpressionNode node = stack.pop().inline();
        if (!stack.isEmpty()) {
            throw new InvalidExpressionException("Tried to make an expression with too many nodes! (" + stack + ")");
        }
        return node;
    }

    public static boolean isValidDouble(String op) {
        return DOUBLE_MATCHER.matcher(op).matches();
    }

    public static boolean isValidLong(String value) {
        return LONG_MATCHER.matcher(value).matches();
    }

    public static long parseValidLong(String value) {
        long val;
        if (value.startsWith("0x")) {
            String v = value.substring(2).replace("_", rightAssociative);
            val = Long.parseLong(v, 16);
        } else {
            val = Long.parseLong(value);
        }
        return val;
    }

    public static IExpressionNode convertBinary(IExpressionNode convert, IExpressionNode compare) throws InvalidExpressionException {
        if (convert instanceof IExpressionNode.INodeDouble) {
            if (compare instanceof IExpressionNode.INodeDouble) {
                return convert;
            }
            if (compare instanceof IExpressionNode.INodeLong) {
                return convert;
            }
            if (compare instanceof IExpressionNode.INodeString) {
                return new NodeCastDoubleToString((IExpressionNode.INodeDouble)convert);
            }
            throw new InvalidExpressionException("Cannot convert " + convert + " with " + compare);
        }
        if (convert instanceof IExpressionNode.INodeLong) {
            if (compare instanceof IExpressionNode.INodeDouble) {
                return new NodeCastLongToDouble((IExpressionNode.INodeLong)convert);
            }
            if (compare instanceof IExpressionNode.INodeLong) {
                return convert;
            }
            if (compare instanceof IExpressionNode.INodeString) {
                return new NodeCastLongToString((IExpressionNode.INodeLong)convert);
            }
            throw new InvalidExpressionException("Cannot convert " + convert + " with " + compare);
        }
        if (convert instanceof IExpressionNode.INodeString) {
            return convert;
        }
        if (convert instanceof IExpressionNode.INodeBoolean) {
            if (compare instanceof IExpressionNode.INodeBoolean) {
                return convert;
            }
            if (compare instanceof IExpressionNode.INodeString) {
                return new NodeCastBooleanToString((IExpressionNode.INodeBoolean)convert);
            }
            throw new InvalidExpressionException("Cannot convert " + convert + " with " + compare);
        }
        throw new InvalidExpressionException("Unknown type " + convert);
    }

    private static void pushBiNode(NodeStack stack, IBinaryNodeType type) throws InvalidExpressionException {
        IExpressionNode right = stack.pop();
        IExpressionNode left = stack.pop();
        stack.push(type.createNode(left, right));
    }

    private static void pushUnaryNode(NodeStack stack, IUnaryNodeType type) throws InvalidExpressionException {
        IExpressionNode node = stack.pop();
        if (node instanceof IExpressionNode.INodeLong) {
            stack.push(type.createLongNode((IExpressionNode.INodeLong)node));
        } else if (node instanceof IExpressionNode.INodeDouble) {
            stack.push(type.createDoubleNode((IExpressionNode.INodeDouble)node));
        } else if (node instanceof IExpressionNode.INodeBoolean) {
            stack.push(type.createBooleanNode((IExpressionNode.INodeBoolean)node));
        } else if (node instanceof IExpressionNode.INodeString) {
            stack.push(type.createStringNode((IExpressionNode.INodeString)node));
        } else {
            throw new InvalidExpressionException("Unknown node " + node);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void pushConditional(NodeStack stack) throws InvalidExpressionException {
        IExpressionNode right = stack.pop();
        IExpressionNode left = stack.pop();
        IExpressionNode conditional = stack.pop();
        right = InternalCompiler.convertBinary(right, left);
        left = InternalCompiler.convertBinary(left, right);
        if (!(conditional instanceof IExpressionNode.INodeBoolean)) throw new InvalidExpressionException("Required a boolean node, but got '" + conditional + "' of " + conditional.getClass());
        IExpressionNode.INodeBoolean condition = (IExpressionNode.INodeBoolean)conditional;
        if (right instanceof IExpressionNode.INodeBoolean) {
            stack.push(new NodeConditionalBoolean(condition, (IExpressionNode.INodeBoolean)left, (IExpressionNode.INodeBoolean)right));
            return;
        } else if (right instanceof IExpressionNode.INodeDouble) {
            stack.push(new NodeConditionalDouble(condition, (IExpressionNode.INodeDouble)left, (IExpressionNode.INodeDouble)right));
            return;
        } else if (right instanceof IExpressionNode.INodeString) {
            stack.push(new NodeConditionalString(condition, (IExpressionNode.INodeString)left, (IExpressionNode.INodeString)right));
            return;
        } else {
            if (!(right instanceof IExpressionNode.INodeLong)) throw new InvalidExpressionException("Unknown node " + left);
            stack.push(new NodeConditionalLong(condition, (IExpressionNode.INodeLong)left, (IExpressionNode.INodeLong)right));
        }
    }

    private static void pushFunctionNode(NodeStack stack, String function, FunctionContext context) throws InvalidExpressionException {
        INodeFunc func;
        String name = function.substring(0, function.indexOf(FUNCTION_ARGS));
        String argCount = function.substring(function.indexOf(FUNCTION_ARGS) + 1);
        int count = Integer.parseInt(argCount);
        if (name.startsWith(".")) {
            name = name.substring(1);
            ++count;
        }
        if ((func = context.getFunction(name, count)) == null) {
            throw new InvalidExpressionException("Unknown function '" + name + "'");
        }
        NodeStackRecording recorder = new NodeStackRecording();
        func.getNode(recorder);
        if (recorder.types.size() != count) {
            throw new InvalidExpressionException("The function " + name + " takes " + recorder.types + " but only " + count + " were given!");
        }
        stack.setRecorder(recorder.types, func);
        IExpressionNode node = func.getNode(stack);
        stack.checkAndRemoveRecorder();
        stack.push(node);
    }
}

