/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.Argument;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.InternalCompiler;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.cast.NodeCasting;

public class GenericExpressionCompiler {
    public static IExpressionNode.INodeLong compileExpressionLong(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionLong(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeLong compileExpressionLong(String function, FunctionContext context) throws InvalidExpressionException {
        IExpressionNode node = InternalCompiler.compileExpression(function, context);
        if (node instanceof IExpressionNode.INodeLong) {
            return (IExpressionNode.INodeLong)node;
        }
        throw new InvalidExpressionException("Not a long " + node);
    }

    public static INodeFunc.INodeFuncLong compileFunctionLong(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionLong(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncLong compileFunctionLong(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        INodeFunc func = InternalCompiler.compileFunction(function, context, args);
        if (func instanceof INodeFunc.INodeFuncLong) {
            return (INodeFunc.INodeFuncLong)func;
        }
        throw new InvalidExpressionException("Not a long " + func);
    }

    public static IExpressionNode.INodeDouble compileExpressionDouble(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionDouble(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeDouble compileExpressionDouble(String function, FunctionContext context) throws InvalidExpressionException {
        return NodeCasting.castToDouble(InternalCompiler.compileExpression(function, context)).inline();
    }

    public static INodeFunc.INodeFuncDouble compileFunctionDouble(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionDouble(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncDouble compileFunctionDouble(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        return NodeCasting.castToDouble(InternalCompiler.compileFunction(function, context, args));
    }

    public static IExpressionNode.INodeBoolean compileExpressionBoolean(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionBoolean(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeBoolean compileExpressionBoolean(String function, FunctionContext context) throws InvalidExpressionException {
        IExpressionNode node = InternalCompiler.compileExpression(function, context);
        if (node instanceof IExpressionNode.INodeBoolean) {
            return (IExpressionNode.INodeBoolean)node;
        }
        throw new InvalidExpressionException("Not a boolean " + node);
    }

    public static INodeFunc.INodeFuncBoolean compileFunctionBoolean(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionBoolean(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncBoolean compileFunctionBoolean(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        INodeFunc func = InternalCompiler.compileFunction(function, context, args);
        if (func instanceof INodeFunc.INodeFuncBoolean) {
            return (INodeFunc.INodeFuncBoolean)func;
        }
        throw new InvalidExpressionException("Not a boolean " + func);
    }

    public static IExpressionNode.INodeString compileExpressionString(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionString(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeString compileExpressionString(String function, FunctionContext context) throws InvalidExpressionException {
        return NodeCasting.castToString(InternalCompiler.compileExpression(function, context)).inline();
    }

    public static INodeFunc.INodeFuncString compileFunctionString(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionString(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncString compileFunctionString(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        return NodeCasting.castToString(InternalCompiler.compileFunction(function, context, args));
    }
}

