/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.InternalCompiler;
import buildcraft.lib.expression.NodeStackRecording;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.node.func.NodeFuncDoubleDoubleToDouble;
import buildcraft.lib.expression.node.func.NodeFuncDoubleToDouble;
import buildcraft.lib.expression.node.func.NodeFuncDoubleToLong;
import buildcraft.lib.expression.node.func.NodeFuncLongLongToLong;
import buildcraft.lib.expression.node.func.NodeFuncLongToLong;
import buildcraft.lib.expression.node.func.NodeFuncStringToLong;
import buildcraft.lib.expression.node.func.NodeFuncToBoolean;
import buildcraft.lib.expression.node.func.NodeFuncToString;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.expression.node.value.NodeConstantString;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableLong;
import buildcraft.lib.expression.node.value.NodeVariableString;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FunctionContext {
    public static final String FUNCTION_ARG_SEPARATOR = "^";
    private final FunctionContext[] parents;
    private final Map<String, IExpressionNode> variables = new HashMap<String, IExpressionNode>();
    private final Map<String, INodeFunc> functions = new HashMap<String, INodeFunc>();

    public FunctionContext() {
        this.parents = new FunctionContext[0];
    }

    public FunctionContext(FunctionContext parent) {
        this.parents = new FunctionContext[]{parent};
    }

    public FunctionContext(FunctionContext[] parents) {
        this.parents = (FunctionContext[])parents.clone();
    }

    public IExpressionNode getVariable(String name) {
        IExpressionNode current = this.variables.get(name = name.toLowerCase(Locale.ROOT));
        if (current != null) {
            return current;
        }
        for (FunctionContext parent : this.parents) {
            IExpressionNode node = parent.getVariable(name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public boolean hasLocalVariable(String name) {
        name = name.toLowerCase(Locale.ROOT);
        return this.variables.containsKey(name);
    }

    public <E extends IExpressionNode> E putVariable(String name, E node) {
        name = name.toLowerCase(Locale.ROOT);
        this.variables.put(name, node);
        return node;
    }

    public IVariableNode putVariable(String name, NodeType type) {
        switch (type) {
            case BOOLEAN: {
                return this.putVariableBoolean(name);
            }
            case DOUBLE: {
                return this.putVariableDouble(name);
            }
            case LONG: {
                return this.putVariableLong(name);
            }
            case STRING: {
                return this.putVariableString(name);
            }
        }
        throw new IllegalArgumentException("Unknown node type " + (Object)((Object)type));
    }

    public NodeVariableLong putVariableLong(String name) {
        NodeVariableLong node = new NodeVariableLong(name);
        return this.putVariable(name, node);
    }

    public NodeVariableDouble putVariableDouble(String name) {
        NodeVariableDouble node = new NodeVariableDouble(name);
        return this.putVariable(name, node);
    }

    public NodeVariableBoolean putVariableBoolean(String name) {
        NodeVariableBoolean node = new NodeVariableBoolean(name);
        return this.putVariable(name, node);
    }

    public NodeVariableString putVariableString(String name) {
        NodeVariableString node = new NodeVariableString(name);
        return this.putVariable(name, node);
    }

    public void putConstantLong(final String name, long value) {
        this.putVariable(name, new NodeConstantLong(value){

            @Override
            public String toString() {
                return name;
            }
        });
    }

    public void putConstantDouble(final String name, double value) {
        this.putVariable(name, new NodeConstantDouble(value){

            @Override
            public String toString() {
                return name;
            }
        });
    }

    public void putConstantBoolean(final String name, final boolean value) {
        this.putVariable(name, new IExpressionNode.INodeBoolean(){

            @Override
            public boolean evaluate() {
                return value;
            }

            @Override
            public IExpressionNode.INodeBoolean inline() {
                return NodeConstantBoolean.get(value);
            }

            public String toString() {
                return name;
            }
        });
    }

    public void putConstantString(final String name, String value) {
        this.putVariable(name, new NodeConstantString(value){

            @Override
            public String toString() {
                return name;
            }
        });
    }

    public void putParsedConstant(String name, String value) {
        if (InternalCompiler.isValidLong(value)) {
            this.putConstantLong(name, InternalCompiler.parseValidLong(value));
        } else if (InternalCompiler.isValidDouble(value)) {
            this.putConstantDouble(name, Double.parseDouble(value));
        } else if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            this.putConstantBoolean(name, "true".equalsIgnoreCase(value));
        } else {
            this.putConstantString(name, value);
        }
    }

    public INodeFunc getFunction(String name, int args) {
        name = name.toLowerCase(Locale.ROOT);
        return this.getFunction0(name + FUNCTION_ARG_SEPARATOR + args);
    }

    private INodeFunc getFunction0(String fullName) {
        INodeFunc current = this.functions.get(fullName);
        if (current != null) {
            return current;
        }
        for (FunctionContext parent : this.parents) {
            INodeFunc func = parent.getFunction0(fullName);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    private static int getArgCount(INodeFunc function) {
        NodeStackRecording recorder = new NodeStackRecording();
        try {
            function.getNode(recorder);
        }
        catch (InvalidExpressionException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
        return recorder.types.size();
    }

    public <F extends INodeFunc> F putFunction(String name, F function) {
        name = name.toLowerCase(Locale.ROOT);
        this.functions.put(name + FUNCTION_ARG_SEPARATOR + FunctionContext.getArgCount(function), function);
        return function;
    }

    public INodeFunc.INodeFuncBoolean put_b(String name, NodeFuncToBoolean.IFuncToBoolean func) {
        return this.putFunction(name, new NodeFuncToBoolean(name, func));
    }

    public INodeFunc.INodeFuncString put_s(String name, NodeFuncToString.IFuncToString func) {
        return this.putFunction(name, new NodeFuncToString(name, func));
    }

    public INodeFunc.INodeFuncLong put_l_l(String name, NodeFuncLongToLong.IFuncLongToLong func) {
        return this.putFunction(name, new NodeFuncLongToLong(func, a -> name + "(" + a + ")"));
    }

    public INodeFunc.INodeFuncLong put_ll_l(String name, NodeFuncLongLongToLong.IFuncLongLongToLong func) {
        return this.putFunction(name, new NodeFuncLongLongToLong(func, (a, b) -> name + "(" + a + ", " + b + ")"));
    }

    public INodeFunc.INodeFuncLong put_d_l(String name, NodeFuncDoubleToLong.IFuncDoubleToLong func) {
        return this.putFunction(name, new NodeFuncDoubleToLong(func, a -> name + "(" + a + ")"));
    }

    public INodeFunc.INodeFuncDouble put_d_d(String name, NodeFuncDoubleToDouble.IFuncDoubleToDouble func) {
        return this.putFunction(name, new NodeFuncDoubleToDouble(func, a -> name + "(" + a + ")"));
    }

    public INodeFunc.INodeFuncDouble put_dd_d(String name, NodeFuncDoubleDoubleToDouble.IFuncDoubleDoubleToDouble func) {
        return this.putFunction(name, new NodeFuncDoubleDoubleToDouble(func, (a, b) -> name + "(" + a + ", " + b + ")"));
    }

    public INodeFunc.INodeFuncLong put_s_l(String name, NodeFuncStringToLong.IFuncStringToLong func) {
        return this.putFunction(name, new NodeFuncStringToLong(func, a -> name + "(" + a + ")"));
    }
}

